/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.util;

import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cost;
import org.neo4j.cypher.internal.util.Multiplier$;
import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.Tuple2;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00013A!\u0002\u0004\u0001#!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003.\u0001\u0011\u0005c\u0006C\u0003=\u0001\u0011%QH\u0001\rCCR\u001c\u0007.\u001a3DCJ$Xm]5b]>\u0013H-\u001a:j]\u001eT!a\u0002\u0005\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011c\u0001\u0001\u00135A\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0005Y\u0006twMC\u0001\u0018\u0003\u0011Q\u0017M^1\n\u0005e!\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001c?9\u0011A$H\u0007\u0002\r%\u0011aDB\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0013EA\tDCJ$Xm]5b]>\u0013H-\u001a:j]\u001eT!A\b\u0004\u0002\u0013\t\fGo\u00195TSj,\u0007C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#aA%oi\u00061A(\u001b8jiz\"\"a\u000b\u0017\u0011\u0005q\u0001\u0001\"\u0002\u0012\u0003\u0001\u0004\u0019\u0013aB2p[B\f'/\u001a\u000b\u0004G=R\u0004\"\u0002\u0019\u0004\u0001\u0004\t\u0014!B:jI\u0016\u0004\u0004\u0003\u0002\u00133i]J!aM\u0013\u0003\rQ+\b\u000f\\33!\taR'\u0003\u00027\r\t!1i\\:u!\ta\u0002(\u0003\u0002:\r\tY1)\u0019:eS:\fG.\u001b;z\u0011\u0015Y4\u00011\u00012\u0003\u0015\u0019\u0018\u000eZ32\u0003\u001d\u0019wn\u001d;G_J$2\u0001\u000e @\u0011\u0015\u0001D\u00011\u00012\u0011\u0015YD\u00011\u00012\u0001")
public class BatchedCartesianOrdering
implements Ordering<Tuple2<Cost, Cardinality>> {
    private final int batchSize;

    public Some tryCompare(Object x, Object y) {
        return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lteq(Object x, Object y) {
        return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gteq(Object x, Object y) {
        return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lt(Object x, Object y) {
        return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gt(Object x, Object y) {
        return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean equiv(Object x, Object y) {
        return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
    }

    public Object max(Object x, Object y) {
        return Ordering.max$((Ordering)this, (Object)x, (Object)y);
    }

    public Object min(Object x, Object y) {
        return Ordering.min$((Ordering)this, (Object)x, (Object)y);
    }

    public Ordering<Tuple2<Cost, Cardinality>> reverse() {
        return Ordering.reverse$((Ordering)this);
    }

    public boolean isReverseOf(Ordering<?> other) {
        return Ordering.isReverseOf$((Ordering)this, other);
    }

    public <U> Ordering<U> on(Function1<U, Tuple2<Cost, Cardinality>> f) {
        return Ordering.on$((Ordering)this, f);
    }

    public Ordering<Tuple2<Cost, Cardinality>> orElse(Ordering<Tuple2<Cost, Cardinality>> other) {
        return Ordering.orElse$((Ordering)this, other);
    }

    public <S> Ordering<Tuple2<Cost, Cardinality>> orElseBy(Function1<Tuple2<Cost, Cardinality>, S> f, Ordering<S> ord) {
        return Ordering.orElseBy$((Ordering)this, f, ord);
    }

    public Ordering.OrderingOps mkOrderingOps(Object lhs) {
        return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
    }

    public int compare(Tuple2<Cost, Cardinality> side0, Tuple2<Cost, Cardinality> side1) {
        return this.costFor(side0, side1).compare(this.costFor(side1, side0));
    }

    private Cost costFor(Tuple2<Cost, Cardinality> side0, Tuple2<Cost, Cardinality> side1) {
        Tuple2 tuple2 = new Tuple2(side0, side1);
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Tuple2 tuple23 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                Cost cost0 = (Cost)tuple22._1();
                Cardinality cardinality = (Cardinality)tuple22._2();
                if (cardinality != null) {
                    double card0 = cardinality.amount();
                    if (tuple23 != null) {
                        Cost cost1 = (Cost)tuple23._1();
                        return cost0.$plus(cost1.$times(Multiplier$.MODULE$.lift(Math.ceil(card0 / (double)this.batchSize))));
                    }
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public BatchedCartesianOrdering(int batchSize) {
        this.batchSize = batchSize;
        PartialOrdering.$init$((PartialOrdering)this);
        Ordering.$init$((Ordering)this);
    }
}

