/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyFloatIterable;

public class TapFloatIterable
extends AbstractLazyFloatIterable {
    private final FloatIterable adapted;
    private final FloatProcedure procedure;

    public TapFloatIterable(FloatIterable delegate, FloatProcedure procedure) {
        this.adapted = delegate;
        this.procedure = procedure;
    }

    public void each(FloatProcedure procedure) {
        this.adapted.forEach((FloatProcedure & Serializable)each -> {
            this.procedure.value(each);
            procedure.value(each);
        });
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return this.adapted.anySatisfy((FloatPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return this.adapted.allSatisfy((FloatPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.adapted.noneSatisfy((FloatPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.adapted.detectIfNone((FloatPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        }, ifNone);
    }

    public FloatIterator floatIterator() {
        return new TapFloatIterator(this.adapted, this.procedure);
    }

    public static class TapFloatIterator
    implements FloatIterator {
        private final FloatIterator iterator;
        private final FloatProcedure procedure;

        public TapFloatIterator(FloatIterable iterable, FloatProcedure procedure) {
            this(iterable.floatIterator(), procedure);
        }

        public TapFloatIterator(FloatIterator iterator, FloatProcedure procedure) {
            this.iterator = iterator;
            this.procedure = procedure;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public float next() {
            float next = this.iterator.next();
            this.procedure.value(next);
            return next;
        }
    }
}

