/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.prettifier;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.EdgeType;
import org.neo4j.cypher.internal.ast.EdgeTypeReferenceByIdentifyingLabel;
import org.neo4j.cypher.internal.ast.EdgeTypeReferenceByLabel;
import org.neo4j.cypher.internal.ast.EdgeTypeReferenceByVariable;
import org.neo4j.cypher.internal.ast.EmptyNodeTypeReference;
import org.neo4j.cypher.internal.ast.GraphType;
import org.neo4j.cypher.internal.ast.GraphTypeConstraint;
import org.neo4j.cypher.internal.ast.GraphTypeConstraintDefinition;
import org.neo4j.cypher.internal.ast.GraphTypeConstraintName;
import org.neo4j.cypher.internal.ast.GraphTypeElementReference;
import org.neo4j.cypher.internal.ast.GraphTypeEntry;
import org.neo4j.cypher.internal.ast.NodeType;
import org.neo4j.cypher.internal.ast.NodeTypeReferenceByIdentifyingLabel;
import org.neo4j.cypher.internal.ast.NodeTypeReferenceByLabel;
import org.neo4j.cypher.internal.ast.NodeTypeReferenceByVariable;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.ast.PropertyType;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.ast.prettifier.GraphTypeStringifier$GraphTypeConstraintBodyOrdering$;
import org.neo4j.cypher.internal.ast.prettifier.GraphTypeStringifier$GraphTypeConstraintOrdering$;
import org.neo4j.cypher.internal.ast.prettifier.GraphTypeStringifier$GraphTypeEntryOrdering$;
import org.neo4j.cypher.internal.ast.prettifier.GraphTypeStringifier$PropertyTypeOrdering$;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.SymbolicName;
import org.neo4j.cypher.internal.expressions.Variable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;

public final class GraphTypeStringifier$ {
    public static final GraphTypeStringifier$ MODULE$ = new GraphTypeStringifier$();
    private static final String NL = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |"));
    private static final ExpressionStringifier es;

    static {
        boolean x$1 = true;
        boolean x$2 = true;
        Function1<Expression, String> x$3 = ExpressionStringifier$.MODULE$.apply$default$1();
        boolean x$4 = ExpressionStringifier$.MODULE$.apply$default$4();
        boolean x$5 = ExpressionStringifier$.MODULE$.apply$default$5();
        es = ExpressionStringifier$.MODULE$.apply(x$3, true, true, x$4, x$5);
    }

    private String NL() {
        return NL;
    }

    private ExpressionStringifier es() {
        return es;
    }

    public String apply(GraphType graphType) {
        List graphTypeEntries = ((List)graphType.types().toList().sorted((Ordering)GraphTypeStringifier$GraphTypeEntryOrdering$.MODULE$)).map((Function1 & Serializable)entry -> MODULE$.stringifyEntry((GraphTypeEntry)entry));
        List graphTypeConstraints = ((List)graphType.constraints().toList().sorted((Ordering)GraphTypeStringifier$GraphTypeConstraintOrdering$.MODULE$)).map((Function1 & Serializable)entry -> MODULE$.stringifyGraphTypeConstraint((GraphTypeConstraint)entry));
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n       | " + ((IterableOnceOps)graphTypeEntries.$plus$plus((IterableOnce)graphTypeConstraints)).mkString("," + this.NL() + " ") + "\n       |}"));
    }

    private String stringifyEntry(GraphTypeEntry graphTypeEntry) {
        GraphTypeEntry graphTypeEntry2 = graphTypeEntry;
        if (graphTypeEntry2 instanceof NodeType) {
            NodeType nodeType = (NodeType)graphTypeEntry2;
            return this.stringifyNodeType(nodeType);
        }
        if (graphTypeEntry2 instanceof EdgeType) {
            EdgeType edgeType = (EdgeType)graphTypeEntry2;
            return this.stringifyEdgeType(edgeType);
        }
        throw new MatchError((Object)graphTypeEntry2);
    }

    public String stringifyNodeType(NodeType nodeType) {
        List list = ((List)nodeType.propertyTypes().toList().sorted((Ordering)GraphTypeStringifier$PropertyTypeOrdering$.MODULE$)).map((Function1 & Serializable)propertyType -> MODULE$.apply((PropertyType)propertyType));
        String propTypes = list.isEmpty() ? "" : list.mkString(" {", ", ", "}");
        List list2 = ((List)nodeType.additionalLabels().toList().sortBy((Function1 & Serializable)x$9 -> x$9.name(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)s -> MODULE$.es().apply((SymbolicName)s));
        String secondaryLabels = list2.isEmpty() ? "" : list2.mkString(" :", "&", "");
        List constraints = ((List)nodeType.constraints().toList().sortBy((Function1 & Serializable)x$10 -> (GraphTypeConstraint.GraphTypeConstraintBody)x$10._1(), (Ordering)GraphTypeStringifier$GraphTypeConstraintBodyOrdering$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                GraphTypeConstraint.GraphTypeConstraintBody graphTypeConstraintBody = (GraphTypeConstraint.GraphTypeConstraintBody)tuple2._1();
                Options options = (Options)tuple2._2();
                return MODULE$.stringifyGraphTypeConstraintBody(graphTypeConstraintBody) + Prettifier$.MODULE$.stringifyOptions(options, MODULE$.es());
            }
            throw new MatchError((Object)tuple2);
        });
        String constraintsStr = constraints.isEmpty() ? "" : constraints.mkString(" ", " ", "");
        return "(" + this.variable(nodeType.variable()) + ":" + this.es().apply((SymbolicName)nodeType.identifyingLabel()) + " =>" + secondaryLabels + propTypes + ")" + constraintsStr;
    }

    public String stringifyEdgeType(EdgeType edgeType) {
        List list = ((List)edgeType.propertyTypes().toList().sorted((Ordering)GraphTypeStringifier$PropertyTypeOrdering$.MODULE$)).map((Function1 & Serializable)propertyType -> MODULE$.apply((PropertyType)propertyType));
        String propTypes = list.isEmpty() ? "" : list.mkString(" {", ", ", "}");
        List constraints = ((List)edgeType.constraints().toList().sortBy((Function1 & Serializable)x$11 -> (GraphTypeConstraint.GraphTypeConstraintBody)x$11._1(), (Ordering)GraphTypeStringifier$GraphTypeConstraintBodyOrdering$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                GraphTypeConstraint.GraphTypeConstraintBody graphTypeConstraintBody = (GraphTypeConstraint.GraphTypeConstraintBody)tuple2._1();
                Options options = (Options)tuple2._2();
                return MODULE$.stringifyGraphTypeConstraintBody(graphTypeConstraintBody) + Prettifier$.MODULE$.stringifyOptions(options, MODULE$.es());
            }
            throw new MatchError((Object)tuple2);
        });
        String constraintsStr = constraints.isEmpty() ? "" : constraints.mkString(" ", " ", "");
        return this.stringifyElementReference(edgeType.src()) + "-[" + this.variable(edgeType.variable()) + ":" + this.es().apply((SymbolicName)edgeType.identifyingLabel()) + " =>" + propTypes + "]->" + this.stringifyElementReference(edgeType.dest()) + constraintsStr;
    }

    private String stringifyGraphTypeConstraint(GraphTypeConstraint constraint) {
        GraphTypeConstraint graphTypeConstraint = constraint;
        if (graphTypeConstraint instanceof GraphTypeConstraintDefinition) {
            GraphTypeConstraintDefinition graphTypeConstraintDefinition = (GraphTypeConstraintDefinition)graphTypeConstraint;
            return this.stringifyGraphTypeConstraintDefinition(graphTypeConstraintDefinition);
        }
        if (graphTypeConstraint instanceof GraphTypeConstraintName) {
            GraphTypeConstraintName graphTypeConstraintName = (GraphTypeConstraintName)graphTypeConstraint;
            String name = graphTypeConstraintName.name();
            return "CONSTRAINT " + this.es().backtick(name);
        }
        throw new MatchError((Object)graphTypeConstraint);
    }

    private String stringifyGraphTypeConstraintDefinition(GraphTypeConstraintDefinition constraint) {
        String constraintSpecificSuffix = this.stringifyGraphTypeConstraintBody(constraint.body());
        String constraintName = (String)constraint.name().map((Function1 & Serializable)n -> MODULE$.es().backtick((String)n) + " ").getOrElse((Function0 & Serializable)() -> "");
        String options = Prettifier$.MODULE$.stringifyOptions(constraint.options(), this.es());
        return "CONSTRAINT " + constraintName + "FOR " + this.stringifyElementReference(constraint.reference()) + " " + constraintSpecificSuffix + options;
    }

    private String stringifyGraphTypeConstraintBody(GraphTypeConstraint.GraphTypeConstraintBody constaintBody) {
        GraphTypeConstraint.GraphTypeConstraintBody graphTypeConstraintBody = constaintBody;
        if (graphTypeConstraintBody instanceof GraphTypeConstraint.PropertyTypeConstraint) {
            GraphTypeConstraint.PropertyTypeConstraint propertyTypeConstraint = (GraphTypeConstraint.PropertyTypeConstraint)graphTypeConstraintBody;
            return "REQUIRE (" + GraphTypeStringifier$.props$1(propertyTypeConstraint.properties()) + ") IS :: " + propertyTypeConstraint.normalizedPropertyType().description();
        }
        if (graphTypeConstraintBody instanceof GraphTypeConstraint.KeyConstraint) {
            GraphTypeConstraint.KeyConstraint keyConstraint = (GraphTypeConstraint.KeyConstraint)graphTypeConstraintBody;
            return "REQUIRE (" + GraphTypeStringifier$.props$1(keyConstraint.properties()) + ") IS KEY";
        }
        if (graphTypeConstraintBody instanceof GraphTypeConstraint.UniquenessConstraint) {
            GraphTypeConstraint.UniquenessConstraint uniquenessConstraint = (GraphTypeConstraint.UniquenessConstraint)graphTypeConstraintBody;
            return "REQUIRE (" + GraphTypeStringifier$.props$1(uniquenessConstraint.properties()) + ") IS UNIQUE";
        }
        if (graphTypeConstraintBody instanceof GraphTypeConstraint.ExistenceConstraint) {
            GraphTypeConstraint.ExistenceConstraint existenceConstraint = (GraphTypeConstraint.ExistenceConstraint)graphTypeConstraintBody;
            return "REQUIRE (" + GraphTypeStringifier$.props$1(existenceConstraint.properties()) + ") IS NOT NULL";
        }
        throw new MatchError((Object)graphTypeConstraintBody);
    }

    /*
     * Unable to fully structure code
     */
    private String apply(PropertyType propertyType) {
        block5: {
            block4: {
                var4_2 = false;
                var5_3 = null;
                var6_4 = propertyType.constraint();
                if (!None$.MODULE$.equals(var6_4)) break block4;
                v0 = "";
                break block5;
            }
            if (!(var6_4 instanceof Some)) ** GOTO lbl-1000
            var4_2 = true;
            var5_3 = (Some)var6_4;
            var7_5 = (PropertyType.PropertyInlineConstraintBody)var5_3.value();
            if (var7_5 instanceof PropertyType.PropertyInlineUniquenessConstraint) {
                v0 = " IS UNIQUE";
            } else if (var4_2 && (var8_6 = (PropertyType.PropertyInlineConstraintBody)var5_3.value()) instanceof PropertyType.PropertyInlineKeyConstraint) {
                v0 = " IS KEY";
            } else {
                throw new MatchError(var6_4);
            }
        }
        constraint = v0;
        return this.es().apply((SymbolicName)propertyType.name()) + " :: " + propertyType.normalizedPropertyType().description() + constraint;
    }

    private String stringifyElementReference(GraphTypeElementReference edgeEndpointLabel) {
        boolean bl = false;
        NodeTypeReferenceByIdentifyingLabel nodeTypeReferenceByIdentifyingLabel = null;
        boolean bl2 = false;
        NodeTypeReferenceByLabel nodeTypeReferenceByLabel = null;
        boolean bl3 = false;
        EdgeTypeReferenceByIdentifyingLabel edgeTypeReferenceByIdentifyingLabel = null;
        boolean bl4 = false;
        EdgeTypeReferenceByLabel edgeTypeReferenceByLabel = null;
        GraphTypeElementReference graphTypeElementReference = edgeEndpointLabel;
        if (graphTypeElementReference instanceof EmptyNodeTypeReference) {
            return "()";
        }
        if (graphTypeElementReference instanceof NodeTypeReferenceByIdentifyingLabel) {
            bl = true;
            nodeTypeReferenceByIdentifyingLabel = (NodeTypeReferenceByIdentifyingLabel)graphTypeElementReference;
            LabelName name = nodeTypeReferenceByIdentifyingLabel.labelName();
            Option<Variable> option = nodeTypeReferenceByIdentifyingLabel.typeReference();
            if (None$.MODULE$.equals(option)) {
                return "(:" + this.es().apply((SymbolicName)name) + " =>)";
            }
        }
        if (bl) {
            LabelName name = nodeTypeReferenceByIdentifyingLabel.labelName();
            Option<Variable> option = nodeTypeReferenceByIdentifyingLabel.typeReference();
            if (option instanceof Some) {
                Some some = (Some)option;
                Variable v = (Variable)some.value();
                return "(" + this.es().apply((Expression)v) + ":" + this.es().apply((SymbolicName)name) + " =>)";
            }
        }
        if (graphTypeElementReference instanceof NodeTypeReferenceByLabel) {
            bl2 = true;
            nodeTypeReferenceByLabel = (NodeTypeReferenceByLabel)graphTypeElementReference;
            LabelName name = nodeTypeReferenceByLabel.labelName();
            Option<Variable> option = nodeTypeReferenceByLabel.typeReference();
            if (None$.MODULE$.equals(option)) {
                return "(:" + this.es().apply((SymbolicName)name) + ")";
            }
        }
        if (bl2) {
            LabelName name = nodeTypeReferenceByLabel.labelName();
            Option<Variable> option = nodeTypeReferenceByLabel.typeReference();
            if (option instanceof Some) {
                Some some = (Some)option;
                Variable v = (Variable)some.value();
                return "(" + this.es().apply((Expression)v) + ":" + this.es().apply((SymbolicName)name) + ")";
            }
        }
        if (graphTypeElementReference instanceof NodeTypeReferenceByVariable) {
            NodeTypeReferenceByVariable nodeTypeReferenceByVariable = (NodeTypeReferenceByVariable)graphTypeElementReference;
            Variable name = nodeTypeReferenceByVariable.typeReference();
            return "(" + this.es().apply((Expression)name) + ")";
        }
        if (graphTypeElementReference instanceof EdgeTypeReferenceByIdentifyingLabel) {
            bl3 = true;
            edgeTypeReferenceByIdentifyingLabel = (EdgeTypeReferenceByIdentifyingLabel)graphTypeElementReference;
            RelTypeName name = edgeTypeReferenceByIdentifyingLabel.relTypeName();
            Option<Variable> option = edgeTypeReferenceByIdentifyingLabel.typeReference();
            if (None$.MODULE$.equals(option)) {
                return "()-[:" + this.es().apply((SymbolicName)name) + " =>]->()";
            }
        }
        if (bl3) {
            RelTypeName name = edgeTypeReferenceByIdentifyingLabel.relTypeName();
            Option<Variable> option = edgeTypeReferenceByIdentifyingLabel.typeReference();
            if (option instanceof Some) {
                Some some = (Some)option;
                Variable v = (Variable)some.value();
                return "()-[" + this.es().apply((Expression)v) + ":" + this.es().apply((SymbolicName)name) + " =>]->()";
            }
        }
        if (graphTypeElementReference instanceof EdgeTypeReferenceByLabel) {
            bl4 = true;
            edgeTypeReferenceByLabel = (EdgeTypeReferenceByLabel)graphTypeElementReference;
            RelTypeName name = edgeTypeReferenceByLabel.relTypeName();
            Option<Variable> option = edgeTypeReferenceByLabel.typeReference();
            if (None$.MODULE$.equals(option)) {
                return "()-[:" + this.es().apply((SymbolicName)name) + "]->()";
            }
        }
        if (bl4) {
            RelTypeName name = edgeTypeReferenceByLabel.relTypeName();
            Option<Variable> option = edgeTypeReferenceByLabel.typeReference();
            if (option instanceof Some) {
                Some some = (Some)option;
                Variable v = (Variable)some.value();
                return "()-[" + this.es().apply((Expression)v) + ":" + this.es().apply((SymbolicName)name) + "]->()";
            }
        }
        if (graphTypeElementReference instanceof EdgeTypeReferenceByVariable) {
            EdgeTypeReferenceByVariable edgeTypeReferenceByVariable = (EdgeTypeReferenceByVariable)graphTypeElementReference;
            Variable v = edgeTypeReferenceByVariable.typeReference();
            return "()-[" + this.es().apply((Expression)v) + "]->()";
        }
        throw new MatchError((Object)graphTypeElementReference);
    }

    private String variable(Option<Variable> variable) {
        Option<Variable> option = variable;
        if (option instanceof Some) {
            Some some = (Some)option;
            Variable v = (Variable)some.value();
            return this.es().apply((Expression)v);
        }
        if (None$.MODULE$.equals(option)) {
            return "";
        }
        throw new MatchError(option);
    }

    private static final String props$1(Seq props) {
        return ((IterableOnceOps)props.map((Function1 & Serializable)prop -> MODULE$.es().apply(prop.map()) + "." + MODULE$.es().apply((SymbolicName)prop.propertyKey()))).mkString(", ");
    }

    private GraphTypeStringifier$() {
    }
}

