/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.NoSuchElementException;
import org.neo4j.collection.AbstractPrefetchingRawIterator;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.Resource;

public interface ResourceRawIterator<T, E extends Exception>
extends RawIterator<T, E>,
Resource {
    public static final ResourceRawIterator<Object, Exception> EMPTY_ITERATOR = ResourceRawIterator.of(new Object[0]);

    public static <T, E extends Exception> ResourceRawIterator<T, E> empty() {
        return EMPTY_ITERATOR;
    }

    public static <T, E extends Exception> ResourceRawIterator<T, E> of(final T ... values) {
        return new ResourceRawIterator<T, E>(){
            private int position;

            @Override
            public boolean hasNext() {
                return this.position < values.length;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return values[this.position++];
                }
                throw new NoSuchElementException();
            }

            public void close() {
            }
        };
    }

    public static <T, EX extends Exception> ResourceRawIterator<T, EX> from(final ThrowingSupplier<T, EX> supplier) {
        return new AbstractPrefetchingRawIterator<T, EX>(){

            @Override
            protected T fetchNextOrNull() throws Exception {
                return supplier.get();
            }

            public void close() {
            }
        };
    }
}

