/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingUnifiedSet;
import org.neo4j.collection.trackable.OrderedAppendSet;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public final class HeapTrackingOrderedAppendSet<V>
extends OrderedAppendSet<V>
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingOrderedAppendSet.class);
    private static final int INITIAL_CHUNK_SIZE = 32;
    private static final int MAX_CHUNK_SIZE = 8192;
    private final MemoryTracker scopedMemoryTracker;
    private final HeapTrackingUnifiedSet<V> set;
    private final Chunk<V> first;
    private Chunk<V> current;

    public static <V> HeapTrackingOrderedAppendSet<V> createOrderedSet(MemoryTracker memoryTracker) {
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        return new HeapTrackingOrderedAppendSet<V>(scopedMemoryTracker);
    }

    private HeapTrackingOrderedAppendSet(MemoryTracker scopedMemoryTracker) {
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.set = HeapTrackingCollections.newSet(scopedMemoryTracker);
        this.first = new Chunk(32, scopedMemoryTracker);
        this.current = this.first;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean add(V value) {
        if (this.set.add(value)) {
            this.addToBuffer(value);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public boolean addWithMemoryTracker(V value, Consumer<MemoryTracker> consumer) {
        if (this.set.add(value)) {
            consumer.accept(this.scopedMemoryTracker);
            this.addToBuffer(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object value) {
        return this.set.contains(value);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public V getFirst() {
        if (this.set.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.first.getFirst();
    }

    @Override
    public V getLast() {
        if (this.set.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.current.getLast();
    }

    @Override
    public V get(int index) {
        Chunk<V> chunk = this.first;
        while (chunk != null) {
            if (index < chunk.cursor) {
                return chunk.get(index);
            }
            index -= chunk.cursor;
            chunk = chunk.next;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Iterator<V> iterator() {
        return new AppendSetIterator<V>(this.first);
    }

    @Override
    public void close() {
        this.current = null;
        this.scopedMemoryTracker.close();
    }

    private void addToBuffer(V value) {
        if (!this.current.add(value)) {
            int newChunkSize = HeapTrackingOrderedAppendSet.grow(this.current.elements.length);
            Chunk newChunk = new Chunk(newChunkSize, this.scopedMemoryTracker);
            this.current.next = newChunk;
            this.current = newChunk;
            this.current.add(value);
        }
    }

    @Override
    public OrderedAppendSet<V> reversedOrderedAppendSet() {
        class ReversedView
        extends OrderedAppendSet<V> {
            ReversedView() {
            }

            @Override
            public int size() {
                return HeapTrackingOrderedAppendSet.this.size();
            }

            @Override
            public boolean contains(Object value) {
                return HeapTrackingOrderedAppendSet.this.contains(value);
            }

            @Override
            public boolean isEmpty() {
                return HeapTrackingOrderedAppendSet.this.isEmpty();
            }

            @Override
            public V getFirst() {
                return HeapTrackingOrderedAppendSet.this.getLast();
            }

            @Override
            public V getLast() {
                return HeapTrackingOrderedAppendSet.this.getFirst();
            }

            @Override
            public V get(int index) {
                return HeapTrackingOrderedAppendSet.this.get(this.size() - index - 1);
            }

            @Override
            public Iterator<V> iterator() {
                return new ApendSetReverseIterator(HeapTrackingOrderedAppendSet.this.first, HeapTrackingOrderedAppendSet.this.current);
            }

            @Override
            public OrderedAppendSet<V> reversedOrderedAppendSet() {
                return HeapTrackingOrderedAppendSet.this;
            }
        }
        return new ReversedView();
    }

    private static int grow(int size) {
        if (size == 8192) {
            return size;
        }
        int newSize = size << 1;
        if (newSize <= 0 || newSize > 8192) {
            return 8192;
        }
        return newSize;
    }

    private static final class Chunk<V> {
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Chunk.class);
        private final Object[] elements;
        private Chunk<V> next;
        private int cursor;

        Chunk(int size, MemoryTracker memoryTracker) {
            memoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.shallowSizeOfObjectArray((int)size));
            this.elements = new Object[size];
        }

        boolean add(V value) {
            if (this.cursor < this.elements.length) {
                this.elements[this.cursor] = value;
                ++this.cursor;
                return true;
            }
            return false;
        }

        V get(int index) {
            return (V)this.elements[index];
        }

        V getFirst() {
            return (V)this.elements[0];
        }

        V getLast() {
            int i = Math.min(this.cursor, this.elements.length) - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            return (V)this.elements[i];
        }
    }

    private static class AppendSetIterator<V>
    implements Iterator<V> {
        private Chunk<V> chunk;
        private Chunk<V> nextChunk;
        private int nextIndex;

        AppendSetIterator(Chunk<V> first) {
            this.nextChunk = first;
            this.chunk = this.nextChunk;
        }

        @Override
        public boolean hasNext() {
            return this.nextChunk != null && this.nextIndex < this.nextChunk.cursor;
        }

        @Override
        public V next() {
            if (this.nextChunk == null) {
                throw new NoSuchElementException();
            }
            int index = this.nextIndex++;
            this.chunk = this.nextChunk;
            if (this.nextIndex >= this.nextChunk.cursor) {
                this.nextChunk = this.nextChunk.next;
                this.nextIndex = 0;
            }
            return (V)this.chunk.elements[index];
        }
    }

    private static class ApendSetReverseIterator<V>
    implements Iterator<V> {
        private final Chunk<V> firstChunk;
        private Chunk<V> currentChunk;
        private Chunk<V> nextChunk;
        private int nextIndex;

        ApendSetReverseIterator(Chunk<V> first, Chunk<V> last) {
            this.firstChunk = first;
            this.nextChunk = last;
            this.currentChunk = this.nextChunk;
            this.nextIndex = this.currentChunk.cursor - 1;
        }

        @Override
        public boolean hasNext() {
            return this.nextChunk != null && this.nextIndex >= 0;
        }

        private Chunk<V> findNextChunk() {
            Chunk<V> chunk = this.firstChunk;
            Chunk<V> current = this.currentChunk;
            while (chunk != current) {
                Chunk next = chunk.next;
                if (next == current) {
                    return chunk;
                }
                chunk = next;
            }
            return null;
        }

        @Override
        public V next() {
            if (this.nextChunk == null) {
                throw new NoSuchElementException();
            }
            int index = this.nextIndex--;
            this.currentChunk = this.nextChunk;
            if (this.nextIndex < 0) {
                this.nextChunk = this.findNextChunk();
                this.nextIndex = this.nextChunk == null ? -1 : this.nextChunk.cursor - 1;
            }
            return (V)this.currentChunk.elements[index];
        }
    }
}

