/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class HeapTrackingUnifiedSet<T>
extends UnifiedSet<T>
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingUnifiedSet.class);
    private final MemoryTracker memoryTracker;
    private int trackedCapacity;

    public static <T> HeapTrackingUnifiedSet<T> createUnifiedSet(MemoryTracker memoryTracker) {
        int initialSizeToAllocate = 16;
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingUnifiedSet.arrayHeapSize(initialSizeToAllocate));
        return new HeapTrackingUnifiedSet<T>(memoryTracker, initialSizeToAllocate);
    }

    public static <T> HeapTrackingUnifiedSet<T> createUnifiedSet(MemoryTracker memoryTracker, Iterable<T> elements) {
        HeapTrackingUnifiedSet<T> set = HeapTrackingUnifiedSet.createUnifiedSet(memoryTracker);
        set.addAllIterable(elements);
        return set;
    }

    private HeapTrackingUnifiedSet(MemoryTracker memoryTracker, int trackedCapacity) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = trackedCapacity;
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingUnifiedSet.arrayHeapSize(sizeToAllocate));
            this.memoryTracker.releaseHeap(HeapTrackingUnifiedSet.arrayHeapSize(this.trackedCapacity));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(SHALLOW_SIZE + HeapTrackingUnifiedSet.arrayHeapSize(this.trackedCapacity));
    }

    @VisibleForTesting
    public static long arrayHeapSize(int arrayLength) {
        return HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * (long)HeapEstimator.OBJECT_REFERENCE_BYTES));
    }
}

