/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.Map;
import java.util.Optional;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.gqlstatus.CommonGqlStatusObject;
import org.neo4j.gqlstatus.Condition;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.gqlstatus.Neo4jDiagnosticRecordProperty;

@PublicApi
public interface ErrorGqlStatusObject
extends CommonGqlStatusObject {
    public static final String DEFAULT_STATUS_CODE = GqlStatusInfoCodes.STATUS_50N42.getStatusString();
    public static final String DEFAULT_STATUS_DESCRIPTION = String.format("%s. %s", Condition.createStandardDescription(GqlStatusInfoCodes.STATUS_50N42.getCondition(), GqlStatusInfoCodes.STATUS_50N42.getSubCondition()), GqlStatusInfoCodes.STATUS_50N42.getMessage(Map.of()));

    public ErrorGqlStatusObject gqlStatusObject();

    public String getMessage();

    public String legacyMessage();

    @Override
    default public String gqlStatus() {
        ErrorGqlStatusObject innerGqlStatusObject = this.gqlStatusObject();
        if (innerGqlStatusObject != null) {
            return innerGqlStatusObject.gqlStatus();
        }
        return DEFAULT_STATUS_CODE;
    }

    @Override
    default public String statusDescription() {
        ErrorGqlStatusObject innerGqlStatusObject = this.gqlStatusObject();
        if (innerGqlStatusObject != null) {
            return innerGqlStatusObject.statusDescription();
        }
        return DEFAULT_STATUS_DESCRIPTION;
    }

    @Override
    default public Map<String, Object> diagnosticRecord() {
        ErrorGqlStatusObject innerGqlStatusObject = this.gqlStatusObject();
        if (innerGqlStatusObject != null) {
            return innerGqlStatusObject.diagnosticRecord();
        }
        return DiagnosticRecord.DEFAULT_DIAGNOSTIC_RECORD;
    }

    default public Optional<ErrorGqlStatusObject> cause() {
        ErrorGqlStatusObject innerGqlStatusObject = this.gqlStatusObject();
        if (innerGqlStatusObject != null) {
            return innerGqlStatusObject.cause();
        }
        return Optional.empty();
    }

    default public ErrorClassification getClassification() {
        Object maybeClassification = this.diagnosticRecord().get(Neo4jDiagnosticRecordProperty.CLASSIFICATION.key());
        if (maybeClassification == null) {
            return ErrorClassification.UNKNOWN;
        }
        return ErrorClassification.valueOf((String)maybeClassification);
    }
}

