/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gqlstatus.DiagnosticRecordProperty;

enum GqlStandardDiagnosticRecordProperty implements DiagnosticRecordProperty<String>
{
    CURRENT_SCHEMA("CURRENT_SCHEMA", "/"),
    OPERATION_CODE("OPERATION_CODE", "0"),
    OPERATION("OPERATION", "");

    private static final Set<DiagnosticRecordProperty<?>> ALL_PROPERTIES;
    private final String defaultValue;
    private final String key;

    private GqlStandardDiagnosticRecordProperty(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    static Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (DiagnosticRecordProperty<?> property : ALL_PROPERTIES) {
            if (property.disabled()) continue;
            property.defaultValue().ifPresent(value -> map.put(property.key(), value));
        }
        return map;
    }

    static Set<DiagnosticRecordProperty<?>> asSet() {
        return ALL_PROPERTIES;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Optional<String> defaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    static {
        ALL_PROPERTIES = Collections.unmodifiableSet(EnumSet.allOf(GqlStandardDiagnosticRecordProperty.class));
    }
}

