/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.memory.DatabaseMemoryGroupTracker;
import org.neo4j.memory.DelegatingMemoryPool;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPoolImpl;
import org.neo4j.memory.MemoryPoolTracker;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;
import org.neo4j.util.Preconditions;

public class GlobalMemoryGroupTracker
extends DelegatingMemoryPool
implements ScopedMemoryPool {
    private final MemoryPools pools;
    private final MemoryGroup group;
    private final List<DatabaseMemoryGroupTracker> databasePools = new CopyOnWriteArrayList<DatabaseMemoryGroupTracker>();
    private final MemoryTracker memoryTracker;
    private final boolean trackingEnabled;

    public GlobalMemoryGroupTracker(MemoryPools pools, MemoryGroup group, long limit, boolean strict, boolean trackingEnabled, String limitSettingName) {
        super(new MemoryPoolImpl(limit, strict, limitSettingName));
        this.pools = pools;
        this.group = group;
        this.trackingEnabled = trackingEnabled;
        this.memoryTracker = trackingEnabled ? new MemoryPoolTracker(this) : EmptyMemoryTracker.INSTANCE;
    }

    void releasePool(DatabaseMemoryGroupTracker databaseMemoryGroupTracker) {
        this.databasePools.remove(databaseMemoryGroupTracker);
    }

    @Override
    public MemoryGroup group() {
        return this.group;
    }

    @Override
    public void close() {
        Preconditions.checkState(this.databasePools.isEmpty(), "All sub pools must be closed before closing top pool");
        this.pools.releasePool(this);
        this.memoryTracker.close();
    }

    public ScopedMemoryPool newDatabasePool(String name, long limit, String limitSettingName) {
        DatabaseMemoryGroupTracker subTracker = new DatabaseMemoryGroupTracker(this, name, limit, true, this.trackingEnabled, true, limitSettingName);
        this.databasePools.add(subTracker);
        return subTracker;
    }

    public ScopedMemoryPool newSystemDatabasePool(String name, long limit, String limitSettingName) {
        DatabaseMemoryGroupTracker subTracker = new DatabaseMemoryGroupTracker(this, name, limit, true, this.trackingEnabled, false, limitSettingName);
        this.databasePools.add(subTracker);
        return subTracker;
    }

    @Override
    public MemoryTracker getPoolMemoryTracker() {
        return this.memoryTracker;
    }

    public List<ScopedMemoryPool> getDatabasePools() {
        return new ArrayList<ScopedMemoryPool>(this.databasePools);
    }
}

