/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;

public final class MemoryPools {
    public static final ScopedMemoryPool NO_TRACKING = new NoTrackingMemoryPool();
    private final List<GlobalMemoryGroupTracker> pools = new CopyOnWriteArrayList<GlobalMemoryGroupTracker>();
    private final boolean trackingEnabled;

    public MemoryPools() {
        this(true);
    }

    public MemoryPools(boolean trackingEnabled) {
        this.trackingEnabled = trackingEnabled;
    }

    public GlobalMemoryGroupTracker pool(MemoryGroup group, long limit, String limitSettingName) {
        return this.pool(group, limit, true, limitSettingName);
    }

    public GlobalMemoryGroupTracker pool(MemoryGroup group, long limit, boolean strict, String limitSettingName) {
        GlobalMemoryGroupTracker pool = new GlobalMemoryGroupTracker(this, group, limit, strict, this.trackingEnabled, limitSettingName);
        this.pools.add(pool);
        return pool;
    }

    public void registerPool(GlobalMemoryGroupTracker pool) {
        this.pools.add(pool);
    }

    public boolean unregisterPool(GlobalMemoryGroupTracker pool) {
        return this.pools.remove(pool);
    }

    public List<GlobalMemoryGroupTracker> getPools() {
        return new ArrayList<GlobalMemoryGroupTracker>(this.pools);
    }

    void releasePool(GlobalMemoryGroupTracker globalMemoryGroupTracker) {
        this.pools.remove(globalMemoryGroupTracker);
    }

    private static class NoTrackingMemoryPool
    implements ScopedMemoryPool {
        private NoTrackingMemoryPool() {
        }

        @Override
        public MemoryGroup group() {
            return MemoryGroup.NO_TRACKING;
        }

        @Override
        public void reserveHeap(long bytes) {
        }

        @Override
        public void reserveHeapNoThrow(long bytes) {
        }

        @Override
        public void reserveNative(long bytes) {
        }

        @Override
        public void reserveNativeNoThrow(long bytes) {
        }

        @Override
        public void releaseHeap(long bytes) {
        }

        @Override
        public void releaseNative(long bytes) {
        }

        @Override
        public long totalSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public long usedHeap() {
            return 0L;
        }

        @Override
        public long usedNative() {
            return 0L;
        }

        @Override
        public long totalUsed() {
            return 0L;
        }

        @Override
        public long free() {
            return Long.MAX_VALUE;
        }

        @Override
        public void close() {
        }

        @Override
        public MemoryTracker getPoolMemoryTracker() {
            return EmptyMemoryTracker.INSTANCE;
        }

        @Override
        public void setSize(long size) {
        }
    }
}

