/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.resources;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public abstract class HeapAllocation {
    public static final HeapAllocation NOT_AVAILABLE = new HeapAllocationNotAvailable();
    public static final HeapAllocation HEAP_ALLOCATION = HeapAllocation.tryLoad(ManagementFactory.getThreadMXBean(), NOT_AVAILABLE);

    public final long allocatedBytes(Thread thread) {
        return this.allocatedBytes(thread.threadId());
    }

    public abstract long allocatedBytes(long var1);

    private static HeapAllocation tryLoad(ThreadMXBean bean, HeapAllocation fallback) {
        try {
            if (bean.getClass().getName().equals("com.sun.management.internal.HotSpotThreadImpl")) {
                return (HeapAllocation)Class.forName("org.neo4j.resources.SunManagementHeapAllocation").getDeclaredMethod("load", ThreadMXBean.class).invoke(null, bean);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return fallback;
    }

    private static class HeapAllocationNotAvailable
    extends HeapAllocation {
        private HeapAllocationNotAvailable() {
        }

        @Override
        public long allocatedBytes(long threadId) {
            return -1L;
        }
    }
}

