/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.collections.api.block.function.Function;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.scheduler.JobHandle;

public class JobHandles {
    public static <T> List<T> getAllResults(Collection<JobHandle<T>> handles) throws ExecutionException {
        ArrayList<T> result = new ArrayList<T>(handles.size());
        Throwable finalError = null;
        for (JobHandle<T> handle : handles) {
            try {
                result.add(handle.get());
            }
            catch (Throwable e) {
                finalError = Exceptions.chain(finalError, e);
            }
        }
        if (finalError != null) {
            throw new ExecutionException(finalError);
        }
        return result;
    }

    public static <T, E extends Exception, F extends Exception> List<T> getAllResults(Collection<JobHandle<T>> handles, Class<E> passThroughException, Function<Throwable, F> fallbackConvertToException) throws E, F {
        try {
            return JobHandles.getAllResults(handles);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ExecutionException) {
                ExecutionException actualExecutionException = (ExecutionException)throwable;
                Throwable cause2 = actualExecutionException.getCause();
                if (passThroughException.isAssignableFrom(cause2.getClass())) {
                    throw (Exception)passThroughException.cast(cause2);
                }
                throw (Exception)fallbackConvertToException.apply((Object)cause2);
            }
            throw (Exception)fallbackConvertToException.apply((Object)e.getCause());
        }
    }
}

