/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.regex.Pattern;
import org.neo4j.util.UnicodeHelper;

public final class Stringifier {
    private static final Pattern UNICODE_ESCAPE_PATTERN = Pattern.compile("([^\\\\])(\\\\u[0-9]{4})");

    public static String backtick(String txt) {
        return Stringifier.backtick(txt, false, false, false);
    }

    public static String backtick(String txt, boolean alwaysBacktick) {
        return Stringifier.backtick(txt, alwaysBacktick, false, false);
    }

    public static String backtick(String txt, boolean alwaysBacktick, boolean globbing) {
        return Stringifier.backtick(txt, alwaysBacktick, globbing, false);
    }

    public static String backtickEmpty(String txt) {
        return Stringifier.backtick(txt, false, false, true);
    }

    public static String backtickEmpty(String txt, boolean globbing) {
        return Stringifier.backtick(txt, false, globbing, true);
    }

    public static String backtick(String txt, boolean alwaysBacktick, boolean globbing, boolean backtickEmpty) {
        String withoutGlobbing = globbing ? txt.replace('*', 'x').replace('?', 'x') : txt;
        boolean needsBackticks = alwaysBacktick || !txt.isEmpty() && !UnicodeHelper.isIdentifierInAllVersions(withoutGlobbing) || backtickEmpty && txt.isEmpty();
        return needsBackticks ? Stringifier.addBackticks(txt) : txt;
    }

    private static String addBackticks(String txt) {
        String bt = txt.replace("`", "``");
        return "`" + UNICODE_ESCAPE_PATTERN.matcher(bt).replaceAll("$1\\\\$2") + "`";
    }
}

