/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.AsyncTransactionCallback;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.async.AsyncAbstractQueryRunner;
import org.neo4j.driver.internal.async.DelegatingAsyncTransactionContext;
import org.neo4j.driver.internal.async.InternalAsyncTransaction;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.observation.util.ObservationUtil;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.internal.util.Futures;

public class InternalAsyncSession
extends AsyncAbstractQueryRunner
implements AsyncSession {
    private final NetworkSession session;
    private final DriverObservationProvider observationProvider;

    public InternalAsyncSession(NetworkSession session, DriverObservationProvider observationProvider) {
        this.session = session;
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(Query query) {
        return this.runAsync(query, TransactionConfig.empty());
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(String query, TransactionConfig config) {
        return this.runAsync(query, Collections.emptyMap(), config);
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.runAsync(new Query(query, parameters), config);
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(Query query, TransactionConfig config) {
        Observation runObservation = this.observationProvider.sessionRun(AsyncSession.class, query.text(), query.parameters());
        return ObservationUtil.observeAsync(runObservation, () -> this.session.runAsync(query, config, runObservation, ResultCursor.class));
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        Observation closeObservation = this.observationProvider.sessionClose(AsyncSession.class);
        return ObservationUtil.observeAsync(closeObservation, () -> this.session.closeAsync(closeObservation));
    }

    @Override
    public CompletionStage<AsyncTransaction> beginTransactionAsync() {
        return this.beginTransactionAsync(TransactionConfig.empty());
    }

    @Override
    public CompletionStage<AsyncTransaction> beginTransactionAsync(TransactionConfig config) {
        Observation beginObservation = this.observationProvider.beginTransaction(AsyncTransaction.class);
        return ObservationUtil.observeAsync(beginObservation, () -> this.session.beginTransactionAsync(config, new ApiTelemetryWork(TelemetryApi.UNMANAGED_TRANSACTION), beginObservation).thenApply(tx -> new InternalAsyncTransaction((UnmanagedTransaction)tx, this.observationProvider, null)));
    }

    @Override
    public <T> CompletionStage<T> executeReadAsync(AsyncTransactionCallback<CompletionStage<T>> callback, TransactionConfig config) {
        return this.transactionAsync(AccessMode.READ, callback, config);
    }

    @Override
    public <T> CompletionStage<T> executeWriteAsync(AsyncTransactionCallback<CompletionStage<T>> callback, TransactionConfig config) {
        return this.transactionAsync(AccessMode.WRITE, callback, config);
    }

    @Override
    public Set<Bookmark> lastBookmarks() {
        return new HashSet<Bookmark>(this.session.lastBookmarks());
    }

    private <T> CompletionStage<T> transactionAsync(AccessMode mode, AsyncTransactionCallback<CompletionStage<T>> work, TransactionConfig config) {
        ApiTelemetryWork apiTelemetryWork = new ApiTelemetryWork(TelemetryApi.MANAGED_TRANSACTION);
        Observation executeObservation = this.observationProvider.sessionExecute(AsyncSession.class, mode);
        return ObservationUtil.observeAsync(executeObservation, () -> this.session.retryLogic().retryAsync(() -> {
            CompletableFuture resultFuture = new CompletableFuture();
            CompletionStage<UnmanagedTransaction> txFuture = this.session.beginTransactionAsync(mode, config, apiTelemetryWork, executeObservation);
            txFuture.whenComplete((tx, completionError) -> {
                Throwable error = Futures.completionExceptionCause(completionError);
                if (error != null) {
                    resultFuture.completeExceptionally(error);
                } else {
                    this.executeWork(resultFuture, (UnmanagedTransaction)tx, work, executeObservation);
                }
            });
            return resultFuture;
        }));
    }

    private <T> void executeWork(CompletableFuture<T> resultFuture, UnmanagedTransaction tx, AsyncTransactionCallback<CompletionStage<T>> work, Observation parentObservation) {
        CompletionStage<Object> workFuture = this.safeExecuteWork(tx, work, parentObservation);
        workFuture.whenComplete((result, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                this.closeTxAfterFailedTransactionWork(tx, resultFuture, error, parentObservation);
            } else if (result instanceof ResultCursor) {
                String message = String.format("%s is not a valid return value, it should be consumed before producing a return value", ResultCursor.class.getName());
                error = new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                this.closeTxAfterFailedTransactionWork(tx, resultFuture, error, parentObservation);
            } else {
                this.closeTxAfterSucceededTransactionWork(tx, resultFuture, result, parentObservation);
            }
        });
    }

    private <T> CompletionStage<T> safeExecuteWork(UnmanagedTransaction tx, AsyncTransactionCallback<CompletionStage<T>> work, Observation parentObservation) {
        try {
            CompletionStage result = ObservationUtil.scoped(this.observationProvider, parentObservation, () -> (CompletionStage)work.execute(new DelegatingAsyncTransactionContext(new InternalAsyncTransaction(tx, this.observationProvider, parentObservation))));
            return result == null ? Futures.completedWithNull() : result;
        }
        catch (Throwable workError) {
            return CompletableFuture.failedFuture(workError);
        }
    }

    private <T> void closeTxAfterFailedTransactionWork(UnmanagedTransaction tx, CompletableFuture<T> resultFuture, Throwable error, Observation parentObservation) {
        tx.closeAsync(parentObservation).whenComplete((ignored, rollbackError) -> {
            if (rollbackError != null) {
                error.addSuppressed((Throwable)rollbackError);
            }
            resultFuture.completeExceptionally(error);
        });
    }

    private <T> void closeTxAfterSucceededTransactionWork(UnmanagedTransaction tx, CompletableFuture<T> resultFuture, T result, Observation parentObservation) {
        tx.closeAsync(true, parentObservation).whenComplete((ignored, completionError) -> {
            Throwable commitError = Futures.completionExceptionCause(completionError);
            if (commitError != null) {
                resultFuture.completeExceptionally(commitError);
            } else {
                resultFuture.complete(result);
            }
        });
    }
}

