/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.pooled.impl;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.BasicResponseHandler;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.exception.BoltFailureException;
import org.neo4j.bolt.connection.message.Message;
import org.neo4j.bolt.connection.message.Messages;
import org.neo4j.bolt.connection.observation.ImmutableObservation;
import org.neo4j.bolt.connection.observation.Observation;
import org.neo4j.bolt.connection.pooled.PooledBoltConnectionSource;
import org.neo4j.bolt.connection.summary.BeginSummary;
import org.neo4j.bolt.connection.summary.CommitSummary;
import org.neo4j.bolt.connection.summary.DiscardSummary;
import org.neo4j.bolt.connection.summary.LogoffSummary;
import org.neo4j.bolt.connection.summary.LogonSummary;
import org.neo4j.bolt.connection.summary.PullSummary;
import org.neo4j.bolt.connection.summary.ResetSummary;
import org.neo4j.bolt.connection.summary.RollbackSummary;
import org.neo4j.bolt.connection.summary.RouteSummary;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.summary.TelemetrySummary;
import org.neo4j.bolt.connection.values.Value;

public class PooledBoltConnection
implements BoltConnection {
    private final BoltConnection delegate;
    private final PooledBoltConnectionSource source;
    private final Runnable releaseRunnable;
    private final Runnable purgeRunnable;
    private final Function<ImmutableObservation, Observation> inUseObservationFunction;
    private volatile Observation inUseObservation;
    private CompletableFuture<Void> closeFuture;

    public PooledBoltConnection(BoltConnection delegate, PooledBoltConnectionSource source, Runnable releaseRunnable, Runnable purgeRunnable, Function<ImmutableObservation, Observation> inUseObservationFunction) {
        this.delegate = Objects.requireNonNull(delegate);
        this.source = Objects.requireNonNull(source);
        this.releaseRunnable = Objects.requireNonNull(releaseRunnable);
        this.purgeRunnable = Objects.requireNonNull(purgeRunnable);
        this.inUseObservationFunction = Objects.requireNonNull(inUseObservationFunction);
    }

    public CompletionStage<Void> writeAndFlush(ResponseHandler handler, List<Message> messages, ImmutableObservation parentObservation) {
        return this.delegate.writeAndFlush((ResponseHandler)new PooledResponseHandler(this.source, handler), messages, parentObservation).whenComplete((ignored, throwable) -> {
            if (throwable != null && this.delegate.state() == BoltConnectionState.CLOSED) {
                this.purgeRunnable.run();
            }
        });
    }

    public CompletionStage<Void> write(List<Message> messages) {
        return this.delegate.write(messages);
    }

    public CompletionStage<Void> forceClose(String reason) {
        return this.delegate.forceClose(reason).whenComplete((closeResult, closeThrowable) -> this.purgeRunnable.run());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture;
        boolean close = false;
        PooledBoltConnection pooledBoltConnection = this;
        synchronized (pooledBoltConnection) {
            if (this.closeFuture == null) {
                this.closeFuture = new CompletableFuture();
                close = true;
            }
            closeFuture = this.closeFuture;
        }
        if (close) {
            Observation inUseObservation = this.inUseObservation;
            if (this.delegate.state() == BoltConnectionState.CLOSED) {
                inUseObservation.stop();
                this.purgeRunnable.run();
                closeFuture.complete(null);
                return closeFuture;
            }
            if (this.delegate.state() == BoltConnectionState.ERROR) {
                inUseObservation.stop();
                this.purgeRunnable.run();
                closeFuture.complete(null);
                return closeFuture;
            }
            BasicResponseHandler resetHandler = new BasicResponseHandler();
            this.delegate.writeAndFlush((ResponseHandler)resetHandler, (Message)Messages.reset(), (ImmutableObservation)inUseObservation).thenCompose(ignored -> resetHandler.summaries()).whenComplete((ignored, throwable) -> {
                inUseObservation.stop();
                if (throwable != null) {
                    this.purgeRunnable.run();
                } else {
                    this.releaseRunnable.run();
                }
                closeFuture.complete(null);
            });
        }
        return closeFuture;
    }

    public CompletionStage<Void> setReadTimeout(Duration duration) {
        return this.delegate.setReadTimeout(duration);
    }

    public BoltConnectionState state() {
        return this.delegate.state();
    }

    public CompletionStage<AuthInfo> authInfo() {
        return this.delegate.authInfo();
    }

    public String serverAgent() {
        return this.delegate.serverAgent();
    }

    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    public BoltProtocolVersion protocolVersion() {
        return this.delegate.protocolVersion();
    }

    public boolean telemetrySupported() {
        return this.delegate.telemetrySupported();
    }

    public boolean serverSideRoutingEnabled() {
        return this.delegate.serverSideRoutingEnabled();
    }

    public Optional<Duration> defaultReadTimeout() {
        return this.delegate.defaultReadTimeout();
    }

    public BoltConnection delegate() {
        return this.delegate;
    }

    public void onUsageStart(ImmutableObservation observationParent) {
        this.inUseObservation = this.inUseObservationFunction.apply(observationParent);
    }

    private record PooledResponseHandler(PooledBoltConnectionSource provider, ResponseHandler handler) implements ResponseHandler
    {
        public void onError(Throwable throwable) {
            BoltFailureException boltFailureException;
            if (throwable instanceof BoltFailureException && "Neo.ClientError.Security.AuthorizationExpired".equals((boltFailureException = (BoltFailureException)throwable).code())) {
                this.provider.onExpired();
            }
            this.handler.onError(throwable);
        }

        public void onBeginSummary(BeginSummary summary) {
            this.handler.onBeginSummary(summary);
        }

        public void onRunSummary(RunSummary summary) {
            this.handler.onRunSummary(summary);
        }

        public void onRecord(List<Value> fields) {
            this.handler.onRecord(fields);
        }

        public void onPullSummary(PullSummary summary) {
            this.handler.onPullSummary(summary);
        }

        public void onDiscardSummary(DiscardSummary summary) {
            this.handler.onDiscardSummary(summary);
        }

        public void onCommitSummary(CommitSummary summary) {
            this.handler.onCommitSummary(summary);
        }

        public void onRollbackSummary(RollbackSummary summary) {
            this.handler.onRollbackSummary(summary);
        }

        public void onResetSummary(ResetSummary summary) {
            this.handler.onResetSummary(summary);
        }

        public void onRouteSummary(RouteSummary summary) {
            this.handler.onRouteSummary(summary);
        }

        public void onLogoffSummary(LogoffSummary summary) {
            this.handler.onLogoffSummary(summary);
        }

        public void onLogonSummary(LogonSummary summary) {
            this.handler.onLogonSummary(summary);
        }

        public void onTelemetrySummary(TelemetrySummary summary) {
            this.handler.onTelemetrySummary(summary);
        }

        public void onIgnored() {
            this.handler.onIgnored();
        }

        public void onComplete() {
            this.handler.onComplete();
        }
    }
}

