/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.security;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class AuthorizationExpiredException
extends GqlRuntimeException
implements Status.HasStatus {
    private static final Status statusCode = Status.Security.AuthorizationExpired;
    public static final String LDAP_AUTH_INFO_EXPIRED = "LDAP authorization info expired.";
    private static final String OIDC_AUTH_INFO_EXPIRED = "OIDC authorization info expired.";

    private AuthorizationExpiredException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    private AuthorizationExpiredException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    public static AuthorizationExpiredException ldapAuthInfoExpired() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFE).build()).build();
        return new AuthorizationExpiredException(gql, LDAP_AUTH_INFO_EXPIRED);
    }

    public static AuthorizationExpiredException oidcAuthInfoExpired() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFE).build()).build();
        return new AuthorizationExpiredException(gql, OIDC_AUTH_INFO_EXPIRED);
    }

    public static AuthorizationExpiredException pluginAuthInfoExpired(String plugin) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFE).build()).build();
        return new AuthorizationExpiredException(gql, "Plugin '" + plugin + "' authorization info expired.");
    }

    public static AuthorizationExpiredException pluginAuthInfoExpiredWithCause(String plugin, Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFE).build()).build();
        return new AuthorizationExpiredException(gql, "Plugin '" + plugin + "' authorization info expired: " + e.getMessage(), e);
    }

    public Status status() {
        return statusCode;
    }
}

