/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Comparator;
import java.util.Iterator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.Equality;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;

public interface SequenceValue
extends Iterable<AnyValue> {
    public long actualSize();

    public int intSize();

    default public boolean isEmpty() {
        return this.actualSize() == 0L;
    }

    default public AnyValue head() {
        if (this.isEmpty()) {
            return Values.NO_VALUE;
        }
        return this.value(0L);
    }

    default public AnyValue last() {
        long size = this.actualSize();
        if (size == 0L) {
            return Values.NO_VALUE;
        }
        return this.value(size - 1L);
    }

    public AnyValue value(long var1);

    @Override
    public Iterator<AnyValue> iterator();

    public IterationPreference iterationPreference();

    public ListValue reverse();

    public ListValue asListValue();

    public String prettyPrint();

    public String getTypeName();

    default public boolean equals(SequenceValue other) {
        if (other == null) {
            return false;
        }
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.equalsUsingRandomAccess(this, other);
        }
        return SequenceValue.equalsUsingIterators(this, other);
    }

    public static boolean equalsUsingRandomAccess(SequenceValue a, SequenceValue b) {
        boolean areEqual;
        boolean bl = areEqual = a.intSize() == b.intSize();
        for (int i = 0; areEqual && i < a.intSize(); ++i) {
            areEqual = a.value(i).equals(b.value(i));
        }
        return areEqual;
    }

    public static Equality ternaryEqualsUsingRandomAccess(SequenceValue a, SequenceValue b) {
        int length = a.intSize();
        if (length != b.intSize()) {
            return Equality.FALSE;
        }
        Equality equivalenceResult = Equality.TRUE;
        for (int i = 0; i < length; ++i) {
            Equality areEqual = a.value(i).ternaryEquals(b.value(i));
            if (areEqual == Equality.UNDEFINED) {
                equivalenceResult = Equality.UNDEFINED;
                continue;
            }
            if (areEqual != Equality.FALSE) continue;
            return Equality.FALSE;
        }
        return equivalenceResult;
    }

    public static boolean equalsUsingIterators(SequenceValue a, SequenceValue b) {
        boolean areEqual = true;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (areEqual && aIterator.hasNext() && bIterator.hasNext()) {
            areEqual = aIterator.next().equals(bIterator.next());
        }
        return areEqual && aIterator.hasNext() == bIterator.hasNext();
    }

    public static Equality ternaryEqualsUsingIterators(SequenceValue a, SequenceValue b) {
        Equality equivalenceResult = Equality.TRUE;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (aIterator.hasNext() && bIterator.hasNext()) {
            Equality areEqual = aIterator.next().ternaryEquals(bIterator.next());
            if (areEqual == Equality.UNDEFINED) {
                equivalenceResult = Equality.UNDEFINED;
                continue;
            }
            if (areEqual != Equality.FALSE) continue;
            return Equality.FALSE;
        }
        return !aIterator.hasNext() && !bIterator.hasNext() ? equivalenceResult : Equality.FALSE;
    }

    default public int compareToSequence(SequenceValue other, Comparator<AnyValue> comparator) {
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.compareUsingRandomAccess(this, other, comparator);
        }
        return SequenceValue.compareUsingIterators(this, other, comparator);
    }

    default public Comparison ternaryCompareToSequence(SequenceValue other, TernaryComparator<AnyValue> comparator) {
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.ternaryCompareUsingRandomAccess(this, other, comparator);
        }
        return SequenceValue.ternaryCompareUsingIterators(this, other, comparator);
    }

    public static int compareUsingRandomAccess(SequenceValue a, SequenceValue b, Comparator<AnyValue> comparator) {
        int x = 0;
        int length = Math.min(a.intSize(), b.intSize());
        for (int i = 0; x == 0 && i < length; ++i) {
            x = comparator.compare(a.value(i), b.value(i));
        }
        if (x == 0) {
            x = a.intSize() - b.intSize();
        }
        return x;
    }

    public static int compareUsingIterators(SequenceValue a, SequenceValue b, Comparator<AnyValue> comparator) {
        int x = 0;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (x == 0 && aIterator.hasNext() && bIterator.hasNext()) {
            x = comparator.compare(aIterator.next(), bIterator.next());
        }
        if (x == 0) {
            x = Boolean.compare(aIterator.hasNext(), bIterator.hasNext());
        }
        return x;
    }

    public static Comparison ternaryCompareUsingRandomAccess(SequenceValue a, SequenceValue b, TernaryComparator<AnyValue> comparator) {
        Comparison cmp = Comparison.EQUAL;
        int length = Math.min(a.intSize(), b.intSize());
        for (int i = 0; cmp == Comparison.EQUAL && i < length; ++i) {
            cmp = comparator.ternaryCompare(a.value(i), b.value(i));
        }
        if (cmp == Comparison.EQUAL) {
            cmp = Comparison.from(a.intSize() - b.intSize());
        }
        return cmp;
    }

    public static Comparison ternaryCompareUsingIterators(SequenceValue a, SequenceValue b, TernaryComparator<AnyValue> comparator) {
        Comparison cmp = Comparison.EQUAL;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (cmp == Comparison.EQUAL && aIterator.hasNext() && bIterator.hasNext()) {
            cmp = comparator.ternaryCompare(aIterator.next(), bIterator.next());
        }
        if (cmp == Comparison.EQUAL) {
            cmp = Comparison.from(Boolean.compare(aIterator.hasNext(), bIterator.hasNext()));
        }
        return cmp;
    }

    default public Equality ternaryEquality(SequenceValue other) {
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.ternaryEqualsUsingRandomAccess(this, other);
        }
        return SequenceValue.ternaryEqualsUsingIterators(this, other);
    }

    default public ListValue flatten(int depth) {
        if (depth == 0) {
            return this.asListValue();
        }
        ListValueBuilder listBuilder = ListValueBuilder.newListBuilder();
        for (AnyValue value : this) {
            if (value instanceof SequenceValue) {
                SequenceValue sequenceValue = (SequenceValue)((Object)value);
                sequenceValue.flatten(depth - 1).forEach(listBuilder::add);
                continue;
            }
            listBuilder.add(value);
        }
        return listBuilder.build();
    }

    default public ListValue insertAt(int index, AnyValue value) {
        if (index == 0) {
            return this.asListValue().prepend(value);
        }
        if (index == this.intSize()) {
            return this.asListValue().append(value);
        }
        return this.asListValue().insertAt(index, value);
    }

    default public ListValue remove(int index) {
        if (index == 0) {
            return this.asListValue().slice(1, this.intSize());
        }
        if (index == this.intSize()) {
            return this.asListValue().slice(0, this.intSize() - 1);
        }
        return this.asListValue().remove(index);
    }

    default public int indexOf(AnyValue value) {
        int index = -1;
        int currentIndex = 0;
        Iterator<AnyValue> iterator = this.iterator();
        while (index == -1 && iterator.hasNext()) {
            if (iterator.next().ternaryEquals(value) == Equality.TRUE) {
                index = currentIndex;
            }
            ++currentIndex;
        }
        return index;
    }

    public static enum IterationPreference {
        RANDOM_ACCESS,
        ITERATION;

    }
}

