/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Locale;
import org.neo4j.exceptions.UnsupportedTemporalUnitException;

public enum DurationFields {
    YEARS("years"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return months / 12L;
        }
    }
    ,
    MONTHS("months"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return months;
        }
    }
    ,
    MONTHS_OF_YEAR("monthsofyear"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return months % 12L;
        }
    }
    ,
    MONTHS_OF_QUARTER("monthsofquarter"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return months % 3L;
        }
    }
    ,
    QUARTERS("quarters"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return months / 3L;
        }
    }
    ,
    QUARTERS_OF_YEAR("quartersofyear"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return months / 3L % 4L;
        }
    }
    ,
    WEEKS("weeks"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return days / 7L;
        }
    }
    ,
    DAYS_OF_WEEK("daysofweek"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return days % 7L;
        }
    }
    ,
    DAYS("days"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return days;
        }
    }
    ,
    HOURS("hours"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return seconds / 3600L;
        }
    }
    ,
    MINUTES_OF_HOUR("minutesofhour"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return seconds / 60L % 60L;
        }
    }
    ,
    MINUTES("minutes"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return seconds / 60L;
        }
    }
    ,
    SECONDS_OF_MINUTE("secondsofminute"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return seconds % 60L;
        }
    }
    ,
    SECONDS("seconds"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return seconds;
        }
    }
    ,
    MILLISECONDS_OF_SECOND("millisecondsofsecond"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return nanos / 1000000L;
        }
    }
    ,
    MILLISECONDS("milliseconds"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return seconds * 1000L + nanos / 1000000L;
        }
    }
    ,
    MICROSECONDS_OF_SECOND("microsecondsofsecond"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return nanos / 1000L;
        }
    }
    ,
    MICROSECONDS("microseconds"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return seconds * 1000000L + nanos / 1000L;
        }
    }
    ,
    NANOSECONDS_OF_SECOND("nanosecondsofsecond"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return nanos;
        }
    }
    ,
    NANOSECONDS("nanoseconds"){

        @Override
        public long asTimeStamp(long months, long days, long seconds, long nanos) {
            return seconds * 1000000000L + nanos;
        }
    };

    public final String propertyKey;

    private DurationFields(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public abstract long asTimeStamp(long var1, long var3, long var5, long var7);

    public static DurationFields fromName(String fieldName) {
        return switch (fieldName.toLowerCase(Locale.ROOT)) {
            case "years" -> YEARS;
            case "months" -> MONTHS;
            case "monthsofyear" -> MONTHS_OF_YEAR;
            case "monthsofquarter" -> MONTHS_OF_QUARTER;
            case "quarters" -> QUARTERS;
            case "quartersofyear" -> QUARTERS_OF_YEAR;
            case "weeks" -> WEEKS;
            case "daysofweek" -> DAYS_OF_WEEK;
            case "days" -> DAYS;
            case "hours" -> HOURS;
            case "minutesofhour" -> MINUTES_OF_HOUR;
            case "minutes" -> MINUTES;
            case "secondsofminute" -> SECONDS_OF_MINUTE;
            case "seconds" -> SECONDS;
            case "millisecondsofsecond" -> MILLISECONDS_OF_SECOND;
            case "milliseconds" -> MILLISECONDS;
            case "microsecondsofsecond" -> MICROSECONDS_OF_SECOND;
            case "microseconds" -> MICROSECONDS;
            case "nanosecondsofsecond" -> NANOSECONDS_OF_SECOND;
            case "nanoseconds" -> NANOSECONDS;
            default -> throw UnsupportedTemporalUnitException.noSuchField((String)fieldName, (String)"DURATION");
        };
    }
}

