/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class LongArray
extends IntegralArray {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(LongArray.class);
    private final long[] value;

    LongArray(long[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int intSize() {
        return this.value.length;
    }

    @Override
    public float floatValue(int index) {
        return this.value[index];
    }

    @Override
    public double doubleValue(int index) {
        return this.value[index];
    }

    @Override
    public long longValue(int index) {
        return this.value[index];
    }

    @Override
    protected int computeHashToMemoize() {
        return NumberValues.hash(this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLongArray(this);
    }

    @Override
    public boolean equals(SequenceValue other) {
        if (other instanceof ArrayValue) {
            ArrayValue otherArray = (ArrayValue)other;
            return otherArray.equals(this.value);
        }
        return super.equals(other);
    }

    @Override
    public LongValue value(int offset) {
        return Values.longValue(this.longValue(offset));
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(byte[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(short[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(int[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(long[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public boolean equals(float[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(double[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public long[] asObjectCopy() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Deprecated
    public long[] asObject() {
        return this.value;
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }

    @Override
    public String getTypeName() {
        return "LongArray";
    }

    @Override
    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((long[])this.value);
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof IntegralValue;
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        long[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = ((IntegralValue)added).longValue();
        return new LongArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        long[] newArray = new long[this.value.length + 1];
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        newArray[0] = ((IntegralValue)prepended).longValue();
        return new LongArray(newArray);
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.INT64_ARRAY;
    }
}

