/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import org.neo4j.exceptions.IncomparableValuesException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.FullNodeReference;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public interface CompositeDatabaseValue {
    public long sourceId();

    public static final class CompositeFullNodeReference
    extends FullNodeReference
    implements CompositeDatabaseValue {
        private final long sourceId;

        public CompositeFullNodeReference(long id, String elementId, long sourceId) {
            super(id, elementId);
            this.sourceId = sourceId;
        }

        @Override
        protected boolean equals(VirtualNodeValue other) {
            if (!super.equals(other)) {
                return false;
            }
            if (other instanceof CompositeDatabaseValue) {
                CompositeDatabaseValue compositeValue = (CompositeDatabaseValue)((Object)other);
                return this.sourceId == compositeValue.sourceId();
            }
            if (other instanceof VirtualNodeReference) {
                VirtualNodeReference nodeReference = (VirtualNodeReference)other;
                return this.elementId().equals(nodeReference.elementId());
            }
            throw IncomparableValuesException.internalError((String)this.getClass().getSimpleName(), (String)other.getClass().getSimpleName());
        }

        @Override
        public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
            int idComparison = Long.compare(this.id(), ((VirtualNodeValue)other).id());
            return idComparison != 0 ? idComparison : Long.compare(this.sourceId(), ((CompositeDatabaseValue)((Object)other)).sourceId());
        }

        @Override
        public long sourceId() {
            return this.sourceId;
        }

        @Override
        protected int computeHashToMemoize() {
            return 31 * Long.hashCode(this.id()) + Long.hashCode(this.sourceId);
        }
    }

    public static final class CompositeDirectRelationshipValue
    extends RelationshipValue.DirectRelationshipValue
    implements CompositeDatabaseValue {
        private final long sourceId;

        CompositeDirectRelationshipValue(long id, String elementId, long sourceId, VirtualNodeReference startNode, VirtualNodeReference endNode, TextValue type, MapValue properties, boolean isDeleted) {
            super(id, elementId, startNode, endNode, type, properties, isDeleted);
            this.sourceId = sourceId;
        }

        @Override
        public long sourceId() {
            return this.sourceId;
        }

        @Override
        public boolean equals(VirtualRelationshipValue other) {
            if (!super.equals(other)) {
                return false;
            }
            if (other instanceof CompositeDatabaseValue) {
                CompositeDatabaseValue compositeValue = (CompositeDatabaseValue)((Object)other);
                return this.sourceId == compositeValue.sourceId();
            }
            if (other instanceof RelationshipValue) {
                RelationshipValue relationshipValue = (RelationshipValue)other;
                return this.elementId().equals(relationshipValue.elementId());
            }
            throw IncomparableValuesException.internalError((String)this.getClass().getSimpleName(), (String)other.getClass().getSimpleName());
        }

        @Override
        public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
            int idComparison = Long.compare(this.id(), ((VirtualNodeValue)other).id());
            return idComparison != 0 ? idComparison : Long.compare(this.sourceId(), ((CompositeDatabaseValue)((Object)other)).sourceId());
        }

        @Override
        protected int computeHashToMemoize() {
            return 31 * Long.hashCode(this.id()) + Long.hashCode(this.sourceId);
        }
    }

    public static final class CompositeGraphDirectNodeValue
    extends NodeValue.DirectNodeValue
    implements CompositeDatabaseValue {
        private final long sourceId;

        CompositeGraphDirectNodeValue(long id, String elementId, long sourceId, TextArray labels, MapValue properties, boolean isDeleted) {
            super(id, elementId, labels, properties, isDeleted);
            this.sourceId = sourceId;
        }

        @Override
        public long sourceId() {
            return this.sourceId;
        }

        @Override
        protected boolean equals(VirtualNodeValue other) {
            if (!super.equals(other)) {
                return false;
            }
            if (other instanceof CompositeDatabaseValue) {
                CompositeDatabaseValue compositeValue = (CompositeDatabaseValue)((Object)other);
                return this.sourceId == compositeValue.sourceId();
            }
            if (other instanceof VirtualNodeReference) {
                VirtualNodeReference nodeReference = (VirtualNodeReference)other;
                return this.elementId().equals(nodeReference.elementId());
            }
            throw IncomparableValuesException.internalError((String)this.getClass().getSimpleName(), (String)other.getClass().getSimpleName());
        }

        @Override
        public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
            int idComparison = Long.compare(this.id(), ((VirtualNodeValue)other).id());
            return idComparison != 0 ? idComparison : Long.compare(this.sourceId(), ((CompositeDatabaseValue)((Object)other)).sourceId());
        }

        @Override
        protected int computeHashToMemoize() {
            return 31 * Long.hashCode(this.id()) + Long.hashCode(this.sourceId);
        }
    }
}

