/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.literal.interpreter;

import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.neo4j.cypher.internal.literal.interpreter.LiteralErrorListener;
import org.neo4j.cypher.internal.literal.interpreter.LiteralInterpreterBuilder;
import org.neo4j.cypher.internal.parser.v5.Cypher5Lexer;
import org.neo4j.cypher.internal.parser.v5.Cypher5Parser;
import org.neo4j.exceptions.SyntaxException;

public class Cypher5LiteralInterpreter {
    private Cypher5LiteralInterpreter() {
    }

    public static Object parseExpression(String cypherExpression) {
        Cypher5Parser.ExpressionContext result;
        LiteralInterpreterBuilder builder = new LiteralInterpreterBuilder();
        Cypher5Lexer cypherLexer = new Cypher5Lexer((CharStream)CharStreams.fromString((String)cypherExpression));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)cypherLexer);
        Cypher5Parser parser = new Cypher5Parser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        DefaultErrorStrategy errorStrategy = new DefaultErrorStrategy();
        parser.setErrorHandler((ANTLRErrorStrategy)errorStrategy);
        LiteralErrorListener errorListener = new LiteralErrorListener(cypherExpression);
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        parser.addParseListener((ParseTreeListener)builder);
        try {
            result = parser.expression();
        }
        catch (UnsupportedOperationException e) {
            if (errorListener.error != null) {
                throw errorListener.error;
            }
            throw e;
        }
        if (errorListener.error != null) {
            throw errorListener.error;
        }
        if (!parser.isMatchedEOF() && parser.getInputStream().LA(1) != -1) {
            Integer offset = Optional.ofNullable(parser.getCurrentToken()).map(Token::getStartIndex).orElse(0);
            throw SyntaxException.invalidInput((String)cypherExpression, List.of("valid Cypher expression"), (String)"Invalid cypher expression", (Integer)offset);
        }
        return result.ast;
    }
}

