/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.printer.Printer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AccessMode
implements Command {
    private final CypherShell shell;
    private final Printer printer;

    public AccessMode(CypherShell shell, Printer printer) {
        this.shell = shell;
        this.printer = printer;
    }

    @Override
    public void execute(List<String> args) throws ExitException, CommandException {
        this.requireArgumentCount(args, 0, 1);
        if (args.isEmpty()) {
            this.printer.printOut("Access mode " + String.valueOf((Object)this.shell.accessMode()));
        } else {
            org.neo4j.shell.cli.AccessMode am = org.neo4j.shell.cli.AccessMode.parse(args.get(0)).orElseThrow(() -> this.unknownMode((String)args.get(0)));
            this.shell.reconnect(am);
        }
    }

    private CommandException unknownMode(String in) {
        String available = Arrays.stream(org.neo4j.shell.cli.AccessMode.values()).map(Enum::name).collect(Collectors.joining(", "));
        return new CommandException("Unknown access mode %s, available modes are %s".formatted(in, available));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String help = "View or set access mode";
            String usage = "- Display current access mode\n:access-mode read - Reconnect with read access mode\n:access-mode write - Reconnect with write access mode\n";
            return new Command.Metadata(":access-mode", help, usage, help, List.of());
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new AccessMode(args.cypherShell(), args.printer());
        }
    }
}

