/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.connection;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.exception.BoltClientException;
import org.neo4j.bolt.connection.netty.impl.async.connection.BoltProtocolMinorVersionRange;
import org.neo4j.bolt.connection.netty.impl.async.connection.BoltProtocolUtil;
import org.neo4j.bolt.connection.netty.impl.async.connection.ManifestHandler;
import org.neo4j.bolt.connection.netty.impl.async.connection.VarLongBuilder;
import org.neo4j.bolt.connection.netty.impl.logging.ChannelActivityLogger;
import org.neo4j.bolt.connection.netty.impl.messaging.BoltProtocol;

final class ManifestHandlerV1
implements ManifestHandler {
    private final ChannelActivityLogger log;
    private final Channel channel;
    private final VarLongBuilder expectedVersionRangesBuilder = new VarLongBuilder();
    private final VarLongBuilder capabilitiesBuilder = new VarLongBuilder();
    private final BoltProtocolVersion maxVersion;
    private final long preferredCapabilitiesMask;
    private long expectedVersionRanges = -1L;
    private Set<BoltProtocolMinorVersionRange> serverSupportedVersionRanges;
    private long capabilities = -1L;

    public ManifestHandlerV1(Channel channel, BoltProtocolVersion maxVersion, long preferredCapabilitiesMask, LoggingProvider logging) {
        this.channel = Objects.requireNonNull(channel);
        this.log = new ChannelActivityLogger(channel, logging, this.getClass());
        this.maxVersion = maxVersion;
        this.preferredCapabilitiesMask = preferredCapabilitiesMask;
    }

    @Override
    public void decode(ByteBuf byteBuf) {
        if (this.expectedVersionRanges < 0L) {
            this.decodeExpectedVersionsSegment(byteBuf);
        } else if (this.expectedVersionRanges > 0L) {
            this.decodeServerSupportedBoltVersionRange(byteBuf);
        } else if (this.capabilities < 0L) {
            this.decodeCapabilitiesSegment(byteBuf);
        }
    }

    @Override
    public BoltProtocol complete() {
        return this.findSupportedBoltProtocol();
    }

    private void decodeExpectedVersionsSegment(ByteBuf byteBuf) {
        boolean finished;
        byte segment = byteBuf.readByte();
        byte value = (byte)(0x7F & segment);
        try {
            this.expectedVersionRangesBuilder.add(value);
        }
        catch (IllegalStateException e) {
            throw new BoltClientException("The driver does not support the number of Bolt Protocol version ranges that the server wants to send", (Throwable)e);
        }
        boolean bl = finished = segment >> 7 == 0;
        if (finished) {
            this.expectedVersionRanges = this.expectedVersionRangesBuilder.build();
            int size = (int)this.expectedVersionRanges;
            if (this.expectedVersionRanges != (long)size) {
                throw new BoltClientException("The driver does not support the number of Bolt Protocol version ranges that the server wants to send");
            }
            this.log.log(System.Logger.Level.DEBUG, "S: [Bolt Handshake Manifest] [expected version ranges %d]", this.expectedVersionRanges);
            this.serverSupportedVersionRanges = new HashSet<BoltProtocolMinorVersionRange>(size);
        }
    }

    private void decodeServerSupportedBoltVersionRange(ByteBuf byteBuf) {
        int value = byteBuf.readInt();
        int major = value & 0xFF;
        int minor = value >> 8 & 0xFF;
        int minorNum = value >> 16 & 0xFF;
        this.serverSupportedVersionRanges.add(new BoltProtocolMinorVersionRange(major, minor, minorNum));
        --this.expectedVersionRanges;
        if (this.expectedVersionRanges == 0L) {
            this.log.log(System.Logger.Level.DEBUG, "S: [Bolt Handshake Manifest] [server supported version ranges %s]", this.serverSupportedVersionRanges);
        }
    }

    private void decodeCapabilitiesSegment(ByteBuf byteBuf) {
        boolean finished;
        byte segment = byteBuf.readByte();
        byte value = (byte)(0x7F & segment);
        try {
            this.capabilitiesBuilder.add(value);
        }
        catch (IllegalStateException e) {
            throw new BoltClientException("Failed to handle Bolt capabilities because the server wants to send too many", (Throwable)e);
        }
        boolean bl = finished = segment >> 7 == 0;
        if (finished) {
            this.capabilities = this.capabilitiesBuilder.build();
            this.log.log(System.Logger.Level.DEBUG, "S: [Bolt Handshake Manifest] [capabilities %s]", Long.toBinaryString(value));
        }
    }

    private BoltProtocol findSupportedBoltProtocol() {
        for (Map.Entry<BoltProtocolVersion, BoltProtocol> entry : BoltProtocolUtil.versionToProtocol.entrySet()) {
            BoltProtocolVersion version = entry.getKey();
            if (this.maxVersion != null && version.compareTo(this.maxVersion) > 0) continue;
            for (BoltProtocolMinorVersionRange range : this.serverSupportedVersionRanges) {
                if (!range.contains(version)) continue;
                BoltProtocol protocol = entry.getValue();
                this.write(protocol.version().toInt());
                long selectedCapabilities = this.capabilities & this.preferredCapabilitiesMask;
                this.writeVarLong(selectedCapabilities);
                return protocol;
            }
        }
        this.write(0);
        this.write((byte)0);
        this.channel.flush();
        throw new BoltClientException("No supported Bolt Protocol version was found");
    }

    private void writeVarLong(long value) {
        do {
            byte next = (byte)(value & 0x7FL);
            if ((value >>>= 7) != 0L) {
                next = (byte)(next | 0xFFFFFF80);
            }
            this.write(next);
        } while (value != 0L);
    }

    private void write(int value) {
        this.log.log(System.Logger.Level.DEBUG, "C: [Bolt Handshake Manifest] %s", String.format("[%s]", Integer.toHexString(value)));
        this.channel.write((Object)Unpooled.copyInt((int)value).asReadOnly());
    }

    private void write(byte value) {
        this.log.log(System.Logger.Level.DEBUG, "C: [Bolt Handshake Manifest] %s", String.format("[%s]", Integer.toHexString(value)));
        this.channel.write((Object)Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{value})).asReadOnly());
    }
}

