/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.inbound;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.connection.exception.BoltConnectionInitialisationTimeoutException;
import org.neo4j.bolt.connection.exception.BoltServiceUnavailableException;

public class ConnectTimeoutHandler
extends ReadTimeoutHandler {
    private final long overallTimeoutLimit;
    private boolean triggered;

    public ConnectTimeoutHandler(long timeoutMillis, long overallTimeoutLimit) {
        super(timeoutMillis, TimeUnit.MILLISECONDS);
        this.overallTimeoutLimit = overallTimeoutLimit;
    }

    protected void readTimedOut(ChannelHandlerContext ctx) {
        if (!this.triggered) {
            this.triggered = true;
            ctx.fireExceptionCaught((Throwable)this.unableToConnectError());
        }
    }

    private BoltServiceUnavailableException unableToConnectError() {
        return new BoltConnectionInitialisationTimeoutException("Unable to initialise connection in " + this.overallTimeoutLimit + "ms");
    }
}

