/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.inbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import java.util.Set;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.bolt.connection.netty.impl.async.inbound.ByteBufInput;
import org.neo4j.bolt.connection.netty.impl.async.inbound.InboundMessageDispatcher;
import org.neo4j.bolt.connection.netty.impl.logging.ChannelActivityLogger;
import org.neo4j.bolt.connection.netty.impl.messaging.BoltPatchesListener;
import org.neo4j.bolt.connection.netty.impl.messaging.MessageFormat;
import org.neo4j.bolt.connection.values.ValueFactory;

public class InboundMessageHandler
extends SimpleChannelInboundHandler<ByteBuf>
implements BoltPatchesListener {
    private final ByteBufInput input = new ByteBufInput();
    private final MessageFormat messageFormat;
    private final LoggingProvider logging;
    private final ValueFactory valueFactory;
    private InboundMessageDispatcher messageDispatcher;
    private MessageFormat.Reader reader;
    private System.Logger log;

    public InboundMessageHandler(MessageFormat messageFormat, LoggingProvider logging, ValueFactory valueFactory) {
        this.messageFormat = messageFormat;
        this.logging = logging;
        this.reader = messageFormat.newReader(this.input, valueFactory);
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        this.messageDispatcher = Objects.requireNonNull(ChannelAttributes.messageDispatcher(channel));
        this.log = new ChannelActivityLogger(channel, this.logging, this.getClass());
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.messageDispatcher = null;
        this.log = null;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        if (this.messageDispatcher.fatalErrorOccurred()) {
            this.log.log(System.Logger.Level.WARNING, "Message ignored because of the previous fatal error. Channel will be closed. Message:\n%s", ByteBufUtil.hexDump((ByteBuf)msg));
            return;
        }
        if (this.log.isLoggable(System.Logger.Level.TRACE)) {
            this.log.log(System.Logger.Level.TRACE, "S: %s", ByteBufUtil.hexDump((ByteBuf)msg));
        }
        this.input.start(msg);
        try {
            this.reader.read(this.messageDispatcher);
        }
        catch (Throwable error) {
            throw new DecoderException("Failed to read inbound message:\n" + ByteBufUtil.hexDump((ByteBuf)msg) + "\n", error);
        }
        finally {
            this.input.stop();
        }
    }

    @Override
    public void handle(Set<String> patches) {
        if (patches.contains("utc")) {
            this.messageFormat.enableDateTimeUtc();
            this.reader = this.messageFormat.newReader(this.input, this.valueFactory);
        }
    }
}

