/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class FailedIndexException
extends Neo4jException {
    private FailedIndexException(ErrorGqlStatusObject gqlStatusObject, String indexName, String failureMessage) {
        super(gqlStatusObject, FailedIndexException.msg(indexName, failureMessage), null);
    }

    public static FailedIndexException failedIndex(String indexName, String failureMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N62).withParam(GqlParams.StringParam.idx, indexName).build();
        return new FailedIndexException(gql, indexName, failureMessage);
    }

    private static String msg(String indexName, String failureMessage) {
        String actualFailure = failureMessage != null ? String.format(" Actual failure:%s==================%s%s%s==================", System.lineSeparator(), System.lineSeparator(), failureMessage, System.lineSeparator()) : "";
        return String.format("Index `%s` has failed. Drop and recreate it to get it back online.%s", indexName, actualFailure);
    }

    public Status status() {
        return Status.General.IndexCorruptionDetected;
    }
}

