/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.kernel.api.exceptions.Status;

public class TransactionRetryAbortedException
extends Neo4jException {
    private TransactionRetryAbortedException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    public Status status() {
        return Status.Statement.ExecutionTimeout;
    }

    public static TransactionRetryAbortedException transactionRetryAborted(Throwable cause, int retriedCount, double timeoutInSeconds) {
        DecimalFormat decimalFormat = new DecimalFormat("0.###", DecimalFormatSymbols.getInstance(Locale.ROOT));
        String timeoutString = decimalFormat.format(timeoutInSeconds);
        return new TransactionRetryAbortedException(GqlHelper.get50N23((int)retriedCount, (double)timeoutInSeconds), String.format("Transaction retry aborted after %d attempts. Retry timed out with a maximum retry duration of %s seconds. Last failed with cause: %s", retriedCount, timeoutString, cause.getMessage()), cause);
    }
}

