/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.lang.reflect.Array;
import java.net.URI;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Asterisk;
import org.neo4j.cypherdsl.core.BooleanLiteral;
import org.neo4j.cypherdsl.core.Case;
import org.neo4j.cypherdsl.core.ClausesBasedStatement;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.CountExpression;
import org.neo4j.cypherdsl.core.DecoratedQuery;
import org.neo4j.cypherdsl.core.DurationLiteral;
import org.neo4j.cypherdsl.core.ExposesLoadCSV;
import org.neo4j.cypherdsl.core.ExposesSubqueryCall;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.ForeignAdapter;
import org.neo4j.cypherdsl.core.ForeignAdapterFactory;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.HasLabelCondition;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.InternalNodeImpl;
import org.neo4j.cypherdsl.core.InternalPropertyImpl;
import org.neo4j.cypherdsl.core.LabelExpression;
import org.neo4j.cypherdsl.core.Labels;
import org.neo4j.cypherdsl.core.ListComprehension;
import org.neo4j.cypherdsl.core.ListExpression;
import org.neo4j.cypherdsl.core.ListLiteral;
import org.neo4j.cypherdsl.core.ListOperator;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.LoadCSVStatementBuilder;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.MapLiteral;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Neo4jVersion;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NullLiteral;
import org.neo4j.cypherdsl.core.NumberLiteral;
import org.neo4j.cypherdsl.core.OngoingListBasedPredicateFunction;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternComprehension;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.PeriodLiteral;
import org.neo4j.cypherdsl.core.Predicates;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.RawLiteral;
import org.neo4j.cypherdsl.core.Reduction;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.StringLiteral;
import org.neo4j.cypherdsl.core.SubqueryExpressionBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.TemporalLiteral;
import org.neo4j.cypherdsl.core.UnionQueryImpl;
import org.neo4j.cypherdsl.core.UseClauseImpl;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class Cypher {
    static final ResourceBundle MESSAGES = ResourceBundle.getBundle("org.neo4j.cypherdsl.core.messages");
    private static volatile ForeignAdapterFactory foreignAdapterFactory;

    private Cypher() {
    }

    public static Node node(String primaryLabel, String ... additionalLabels) {
        return new InternalNodeImpl(primaryLabel, additionalLabels);
    }

    public static Node node(String primaryLabel, List<String> additionalLabels) {
        return new InternalNodeImpl(primaryLabel, additionalLabels.toArray(new String[0]));
    }

    public static Node node(String primaryLabel, MapExpression properties, String ... additionalLabels) {
        return new InternalNodeImpl(null, primaryLabel, properties, additionalLabels);
    }

    public static Node node(String primaryLabel, MapExpression properties, Collection<String> additionalLabels) {
        return Cypher.node(primaryLabel, properties, additionalLabels.toArray(new String[0]));
    }

    public static Node anyNode() {
        return new InternalNodeImpl();
    }

    public static Labels exactlyLabel(String label) {
        return Labels.exactly(label);
    }

    public static Labels allLabels(Expression expression) {
        return Labels.all(expression);
    }

    public static Labels anyLabel(Expression expression) {
        return Labels.any(expression);
    }

    @Deprecated(forRemoval=true)
    public static Node node(LabelExpression labelExpression) {
        return Cypher.node(Labels.of(labelExpression));
    }

    public static Node node(Labels labels) {
        return new InternalNodeImpl(Objects.requireNonNull(labels), null);
    }

    public static Asterisk asterisk() {
        return Asterisk.INSTANCE;
    }

    public static Node anyNode(String symbolicName) {
        return new InternalNodeImpl().named(symbolicName);
    }

    public static Node anyNode(SymbolicName symbolicName) {
        return new InternalNodeImpl().named(symbolicName);
    }

    public static Property property(String containerName, String ... names) {
        return Cypher.property((Expression)Cypher.name(containerName), names);
    }

    public static Property property(String containerName, Collection<String> names) {
        return Cypher.property((Expression)Cypher.name(containerName), names.toArray(new String[0]));
    }

    public static Property property(Expression expression, String ... names) {
        return InternalPropertyImpl.create(expression, names);
    }

    public static Property property(Expression expression, Collection<String> names) {
        return Cypher.property(expression, names.toArray(new String[0]));
    }

    public static Property property(String containerName, Expression lookup) {
        return Cypher.property((Expression)Cypher.name(containerName), lookup);
    }

    public static Property property(Expression expression, Expression lookup) {
        return InternalPropertyImpl.create(expression, lookup);
    }

    public static NamedPath.OngoingDefinitionWithName path(String name) {
        return NamedPath.named(name);
    }

    public static NamedPath.OngoingDefinitionWithName path(SymbolicName name) {
        return NamedPath.named(name);
    }

    public static NamedPath.OngoingShortestDefinition shortestK(int k) {
        return NamedPath.shortest(k);
    }

    public static NamedPath.OngoingShortestDefinition shortestKGroups(int k) {
        return NamedPath.shortestKGroups(k);
    }

    public static NamedPath.OngoingShortestDefinition anyShortest() {
        return NamedPath.any();
    }

    public static NamedPath.OngoingShortestDefinition allShortest() {
        return NamedPath.allShortest();
    }

    public static SymbolicName name(String value) {
        return SymbolicName.of(value);
    }

    public static Parameter<Object> parameter(String name) {
        return Parameter.create(name);
    }

    public static <T> Parameter<T> parameter(String name, T value) {
        return Parameter.create(name, value);
    }

    public static <T> Parameter<T> anonParameter(T value) {
        return Parameter.anon(value);
    }

    public static StatementBuilder.OngoingReadingWithoutWhere optionalMatch(PatternElement ... pattern) {
        return Statement.builder().optionalMatch(pattern);
    }

    public static StatementBuilder.OngoingReadingWithoutWhere optionalMatch(Collection<? extends PatternElement> pattern) {
        return Cypher.optionalMatch(pattern.toArray(new PatternElement[0]));
    }

    public static StatementBuilder.OngoingReadingWithoutWhere match(PatternElement ... pattern) {
        return Statement.builder().match(pattern);
    }

    public static StatementBuilder.OngoingReadingWithoutWhere match(Collection<? extends PatternElement> pattern) {
        return Cypher.match(pattern.toArray(new PatternElement[0]));
    }

    public static StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
        return Statement.builder().match(optional, pattern);
    }

    public static StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, Collection<? extends PatternElement> pattern) {
        return Cypher.match(optional, pattern.toArray(new PatternElement[0]));
    }

    public static StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
        return Statement.builder().create(pattern);
    }

    public static StatementBuilder.OngoingUpdate create(Collection<? extends PatternElement> pattern) {
        return Cypher.create(pattern.toArray(new PatternElement[0]));
    }

    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(String ... variables) {
        return Statement.builder().with(variables);
    }

    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(IdentifiableElement ... elements) {
        return Statement.builder().with(elements);
    }

    public static SubqueryExpressionBuilder subqueryWith(String ... identifiableElements) {
        return Cypher.subqueryWith((IdentifiableElement[])Arrays.stream(identifiableElements).map(SymbolicName::of).toArray(SymbolicName[]::new));
    }

    public static SubqueryExpressionBuilder subqueryWith(IdentifiableElement ... identifiableElements) {
        return Expressions.with(identifiableElements);
    }

    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<IdentifiableElement> elements) {
        return Statement.builder().with(elements);
    }

    public static StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
        return Statement.builder().merge(pattern);
    }

    public static StatementBuilder.OngoingMerge merge(Collection<? extends PatternElement> pattern) {
        return Cypher.merge(pattern.toArray(new PatternElement[0]));
    }

    public static StatementBuilder.OngoingUnwind unwind(Expression expression) {
        return Statement.builder().unwind(expression);
    }

    public static StatementBuilder.OngoingUnwind unwind(Expression ... expressions) {
        return Statement.builder().unwind((Expression)Cypher.listOf(expressions));
    }

    public static StatementBuilder.OngoingUnwind unwind(Collection<? extends Expression> expressions) {
        return Cypher.unwind(expressions.toArray(new Expression[0]));
    }

    public static SortItem sort(Expression expression) {
        return SortItem.create(expression, null);
    }

    public static SortItem sort(Expression expression, SortItem.Direction direction) {
        return SortItem.create(expression, direction);
    }

    public static MapExpression mapOf(Object ... keysAndValues) {
        return MapExpression.create(false, keysAndValues);
    }

    public static MapExpression sortedMapOf(Object ... keysAndValues) {
        return MapExpression.create(true, keysAndValues);
    }

    public static MapExpression asExpression(Map<String, Object> map) {
        return MapExpression.create(map);
    }

    public static ListExpression listOf(Expression ... expressions) {
        return ListExpression.create(expressions);
    }

    public static ListExpression listOf(Collection<? extends Expression> expressions) {
        return Cypher.listOf(expressions.toArray(new Expression[0]));
    }

    public static <T> Literal<T> literalOf(Object object) {
        if (object == null) {
            return NullLiteral.INSTANCE;
        }
        if (object instanceof Literal) {
            return (Literal)object;
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return new StringLiteral(charSequence);
        }
        if (object instanceof Character) {
            return new StringLiteral(String.valueOf(object));
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return new NumberLiteral(number);
        }
        if (object instanceof TemporalAccessor) {
            TemporalAccessor temporalAccessor = (TemporalAccessor)object;
            return new TemporalLiteral(temporalAccessor);
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return DurationLiteral.of(duration);
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return PeriodLiteral.of(period);
        }
        if (object instanceof Iterable || object.getClass().isArray()) {
            ArrayList elements = new ArrayList();
            Consumer<Object> handleElement = element -> {
                if (element instanceof Literal) {
                    elements.add((Literal)element);
                } else {
                    try {
                        elements.add(Cypher.literalOf(element));
                    }
                    catch (Literal.UnsupportedLiteralException ex) {
                        throw new Literal.UnsupportedLiteralException("Unsupported literal type in iterable.", element);
                    }
                }
            };
            if (object.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(object); ++i) {
                    handleElement.accept(Array.get(object, i));
                }
            } else {
                ((Iterable)object).forEach(handleElement);
            }
            ListLiteral listLiteral = new ListLiteral(elements);
            return listLiteral;
        }
        if (object instanceof Map) {
            LinkedHashMap map = new LinkedHashMap();
            BiConsumer<Object, Object> handleEntry = (key, value) -> {
                if (!(key instanceof CharSequence) && !(key instanceof Character)) {
                    throw new Literal.UnsupportedLiteralException("Unsupported literal map key (not a string/char type).", key);
                }
                if (value instanceof Literal) {
                    map.put(key.toString(), (Literal)value);
                } else {
                    try {
                        map.put(key.toString(), Cypher.literalOf(value));
                    }
                    catch (Literal.UnsupportedLiteralException ex) {
                        throw new Literal.UnsupportedLiteralException("Unsupported literal type in map.", value);
                    }
                }
            };
            ((Map)object).forEach(handleEntry);
            MapLiteral mapLiteral = new MapLiteral(map);
            return mapLiteral;
        }
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            return BooleanLiteral.of(b);
        }
        throw new Literal.UnsupportedLiteralException(object);
    }

    public static Literal<Boolean> literalTrue() {
        return BooleanLiteral.TRUE;
    }

    public static Literal<Boolean> literalFalse() {
        return BooleanLiteral.FALSE;
    }

    public static Literal<Void> literalNull() {
        return NullLiteral.INSTANCE;
    }

    public static Statement.UnionQuery union(Statement ... statements) {
        return Cypher.unionImpl(false, statements);
    }

    public static Statement.UnionQuery union(Collection<Statement> statements) {
        return Cypher.union(statements.toArray(new Statement[0]));
    }

    public static Statement unionAll(Statement ... statements) {
        return Cypher.unionImpl(true, statements);
    }

    public static Statement unionAll(Collection<Statement> statements) {
        return Cypher.unionAll(statements.toArray(new Statement[0]));
    }

    public static StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
        return Statement.builder().returning(expressions);
    }

    public static StatementBuilder.OngoingReadingAndReturn returning(Collection<? extends Expression> expressions) {
        return Statement.builder().returning(expressions);
    }

    public static PatternComprehension.OngoingDefinitionWithPattern listBasedOn(RelationshipPattern relationshipPattern) {
        return PatternComprehension.basedOn(relationshipPattern);
    }

    public static PatternComprehension.OngoingDefinitionWithPattern listBasedOn(NamedPath namedPath) {
        return PatternComprehension.basedOn(namedPath);
    }

    public static ListComprehension.OngoingDefinitionWithVariable listWith(SymbolicName variable) {
        return ListComprehension.with(variable);
    }

    public static String quote(String unquotedString) {
        return Cypher.literalOf(unquotedString).asString();
    }

    public static Case caseExpression() {
        return Case.create(null);
    }

    public static Case caseExpression(Expression expression) {
        return Case.create(expression);
    }

    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(String procedureName) {
        Assertions.hasText(procedureName, "The procedure name must not be null or empty.");
        return Cypher.call(procedureName.split("\\."));
    }

    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(String ... namespaceAndProcedure) {
        return Statement.call(namespaceAndProcedure);
    }

    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(Collection<String> namespaceAndProcedure) {
        return Cypher.call(namespaceAndProcedure.toArray(new String[0]));
    }

    @Neo4jVersion(minimum="4.0.0")
    public static StatementBuilder.OngoingReadingWithoutWhere call(Statement subquery) {
        return Statement.builder().call(subquery);
    }

    public static Expression subList(Expression targetExpression, Integer start, Integer end) {
        return ListOperator.subList(targetExpression, Cypher.literalOf(start), Cypher.literalOf(end));
    }

    public static Expression subList(Expression targetExpression, Expression start, Expression end) {
        return ListOperator.subList(targetExpression, start, end);
    }

    public static Expression subListFrom(Expression targetExpression, Integer start) {
        return ListOperator.subListFrom(targetExpression, Cypher.literalOf(start));
    }

    public static Expression subListFrom(Expression targetExpression, Expression start) {
        return ListOperator.subListFrom(targetExpression, start);
    }

    public static Expression subListUntil(Expression targetExpression, Integer end) {
        return ListOperator.subListUntil(targetExpression, Cypher.literalOf(end));
    }

    public static Expression subListUntil(Expression targetExpression, Expression end) {
        return ListOperator.subListUntil(targetExpression, end);
    }

    public static ListOperator valueAt(Expression targetExpression, Integer index) {
        return Cypher.valueAt(targetExpression, Cypher.literalOf(index));
    }

    public static ListOperator valueAt(Expression targetExpression, Expression index) {
        return ListOperator.valueAt(targetExpression, index);
    }

    public static Expression raw(String format, Object ... mixedArgs) {
        return RawLiteral.create(format, mixedArgs);
    }

    public static ExposesSubqueryCall.BuildableSubquery callRawCypher(String rawCypher, Object ... args) {
        return Statement.builder().callRawCypher(rawCypher, args);
    }

    public static StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
        return Statement.builder().returningRaw(rawExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <FE> ForeignAdapter<FE> adapt(FE expression) {
        ForeignAdapterFactory initializedForeignAdapterFactory = foreignAdapterFactory;
        if (initializedForeignAdapterFactory != null) return initializedForeignAdapterFactory.getAdapterFor(expression);
        Class<Cypher> clazz = Cypher.class;
        synchronized (Cypher.class) {
            initializedForeignAdapterFactory = foreignAdapterFactory;
            if (initializedForeignAdapterFactory != null) return initializedForeignAdapterFactory.getAdapterFor(expression);
            initializedForeignAdapterFactory = foreignAdapterFactory = new ForeignAdapterFactory();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return initializedForeignAdapterFactory.getAdapterFor(expression);
        }
    }

    public static ExposesLoadCSV usingPeriodicCommit() {
        return Cypher.usingPeriodicCommit(null);
    }

    public static ExposesLoadCSV usingPeriodicCommit(Integer rate) {
        return LoadCSVStatementBuilder.usingPeriodicCommit(rate);
    }

    public static LoadCSVStatementBuilder.OngoingLoadCSV loadCSV(URI from) {
        return Cypher.loadCSV(from, false);
    }

    public static LoadCSVStatementBuilder.OngoingLoadCSV loadCSV(URI from, boolean withHeaders) {
        return LoadCSVStatementBuilder.loadCSV(from, withHeaders);
    }

    private static Statement.UnionQuery unionImpl(boolean unionAll, Statement ... statements) {
        Assertions.isTrue(statements != null && statements.length >= 2, "At least two statements are required!");
        int i = 0;
        UnionQueryImpl existingUnionQuery = null;
        boolean isUnionQuery = statements[0] instanceof UnionQueryImpl;
        if (isUnionQuery) {
            existingUnionQuery = (UnionQueryImpl)statements[0];
            Assertions.isTrue(existingUnionQuery.isAll() == unionAll, "Cannot mix union and union all!");
            i = 1;
        }
        ArrayList<Statement> listOfQueries = new ArrayList<Statement>();
        do {
            Assertions.isTrue(statements[i] instanceof Statement.SingleQuery || statements[i] instanceof ClausesBasedStatement, "Can only union single queries!");
            listOfQueries.add(statements[i]);
        } while (++i < statements.length);
        if (existingUnionQuery == null) {
            return UnionQueryImpl.create(unionAll, listOfQueries);
        }
        return existingUnionQuery.addAdditionalQueries(listOfQueries);
    }

    public static String format(Expression expression) {
        return Expressions.format(expression);
    }

    public static Statement.UseStatement use(String target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Statement.UseStatement use(Parameter<?> target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Statement.UseStatement use(StringLiteral target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Statement.UseStatement use(Expression target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Condition includesAll(Expression lhs, Expression rhs) {
        return Conditions.includesAll(lhs, rhs);
    }

    public static Condition includesAny(Expression lhs, Expression rhs) {
        return Conditions.includesAny(lhs, rhs);
    }

    public static Condition matching(RelationshipPattern relationshipPattern) {
        return Conditions.matching(relationshipPattern);
    }

    public static Condition matches(Expression lhs, Expression rhs) {
        return Conditions.matches(lhs, rhs);
    }

    public static Condition isEqualTo(Expression lhs, Expression rhs) {
        return Conditions.isEqualTo(lhs, rhs);
    }

    public static Condition isNotEqualTo(Expression lhs, Expression rhs) {
        return Conditions.isNotEqualTo(lhs, rhs);
    }

    public static Condition lt(Expression lhs, Expression rhs) {
        return Conditions.lt(lhs, rhs);
    }

    public static Condition lte(Expression lhs, Expression rhs) {
        return Conditions.lte(lhs, rhs);
    }

    public static Condition gte(Expression lhs, Expression rhs) {
        return Conditions.gte(lhs, rhs);
    }

    public static Condition gt(Expression lhs, Expression rhs) {
        return Conditions.gt(lhs, rhs);
    }

    public static Condition not(Condition condition) {
        return Conditions.not(condition);
    }

    public static Condition not(RelationshipPattern pattern) {
        return Conditions.not(pattern);
    }

    public static Condition startsWith(Expression lhs, Expression rhs) {
        return Conditions.startsWith(lhs, rhs);
    }

    public static Condition contains(Expression lhs, Expression rhs) {
        return Conditions.contains(lhs, rhs);
    }

    public static Condition endsWith(Expression lhs, Expression rhs) {
        return Conditions.endsWith(lhs, rhs);
    }

    public static Condition noCondition() {
        return Conditions.noCondition();
    }

    public static Condition isNull(Expression expression) {
        return Conditions.isNull(expression);
    }

    public static Condition isNotNull(Expression expression) {
        return Conditions.isNotNull(expression);
    }

    public static Condition isEmpty(Expression expression) {
        return Predicates.isEmpty(expression);
    }

    public static Condition isTrue() {
        return Conditions.isTrue();
    }

    public static Condition isFalse() {
        return Conditions.isFalse();
    }

    public static Condition hasLabelsOrType(SymbolicName symbolicName, String ... labelsOrTypes) {
        return HasLabelCondition.create(symbolicName, labelsOrTypes);
    }

    public static Condition hasLabelsOrType(SymbolicName symbolicName, Labels labels) {
        return HasLabelCondition.create(symbolicName, labels);
    }

    public static CountExpression count(PatternElement requiredPattern, PatternElement ... patternElement) {
        return Expressions.count(requiredPattern, patternElement);
    }

    public static CountExpression count(Statement.UnionQuery union) {
        return Expressions.count(union);
    }

    public static CountExpression count(Statement statement, IdentifiableElement ... imports) {
        return Expressions.count(statement, imports);
    }

    public static CountExpression count(List<PatternElement> pattern, Where where) {
        return Expressions.count(pattern, where);
    }

    public static Expression collect(Statement statement) {
        return Expressions.collect(statement);
    }

    public static <T extends Expression> Expression nameOrExpression(T expression) {
        return Expressions.nameOrExpression(expression);
    }

    public static SymbolicName[] createSymbolicNames(String[] variables) {
        return Expressions.createSymbolicNames(variables);
    }

    public static SymbolicName[] createSymbolicNames(Named[] variables) {
        return Expressions.createSymbolicNames(variables);
    }

    @Neo4jVersion(minimum="5.0.0")
    public static FunctionInvocation elementId(Node node) {
        return Functions.elementId(node);
    }

    @Neo4jVersion(minimum="5.0.0")
    public static FunctionInvocation elementId(Relationship relationship) {
        return Functions.elementId(relationship);
    }

    public static FunctionInvocation keys(Node node) {
        return Functions.keys(node);
    }

    public static FunctionInvocation keys(Relationship relationship) {
        return Functions.keys(relationship);
    }

    public static FunctionInvocation keys(Expression expression) {
        return Functions.keys(expression);
    }

    public static FunctionInvocation labels(Node node) {
        return Functions.labels(node);
    }

    public static FunctionInvocation labels(SymbolicName node) {
        return Functions.labels(node);
    }

    public static FunctionInvocation type(Relationship relationship) {
        return Functions.type(relationship);
    }

    public static FunctionInvocation type(SymbolicName relationship) {
        return Functions.type(relationship);
    }

    public static FunctionInvocation count(Node node) {
        return Functions.count(node);
    }

    public static FunctionInvocation count(Expression expression) {
        return Functions.count(expression);
    }

    public static FunctionInvocation countDistinct(Node node) {
        return Functions.countDistinct(node);
    }

    public static FunctionInvocation countDistinct(Expression expression) {
        return Functions.countDistinct(expression);
    }

    public static FunctionInvocation properties(Node node) {
        return Functions.properties(node);
    }

    public static FunctionInvocation properties(Relationship relationship) {
        return Functions.properties(relationship);
    }

    public static FunctionInvocation properties(MapExpression map) {
        return Functions.properties(map);
    }

    public static FunctionInvocation coalesce(Expression ... expressions) {
        return Functions.coalesce(expressions);
    }

    public static FunctionInvocation left(Expression expression, Expression length) {
        return Functions.left(expression, length);
    }

    public static FunctionInvocation ltrim(Expression expression) {
        return Functions.ltrim(expression);
    }

    public static FunctionInvocation replace(Expression original, Expression search, Expression replace) {
        return Functions.replace(original, search, replace);
    }

    public static FunctionInvocation reverse(Expression original) {
        return Functions.reverse(original);
    }

    public static FunctionInvocation right(Expression expression, Expression length) {
        return Functions.right(expression, length);
    }

    public static FunctionInvocation rtrim(Expression expression) {
        return Functions.rtrim(expression);
    }

    public static FunctionInvocation substring(Expression original, Expression start, Expression length) {
        return Functions.substring(original, start, length);
    }

    public static FunctionInvocation toLower(Expression expression) {
        return Functions.toLower(expression);
    }

    public static FunctionInvocation toUpper(Expression expression) {
        return Functions.toUpper(expression);
    }

    public static FunctionInvocation trim(Expression expression) {
        return Functions.trim(expression);
    }

    public static FunctionInvocation split(Expression expression, Expression delimiter) {
        return Functions.split(expression, delimiter);
    }

    public static FunctionInvocation split(Expression expression, String delimiter) {
        return Functions.split(expression, delimiter);
    }

    public static FunctionInvocation size(Expression expression) {
        return Functions.size(expression);
    }

    public static FunctionInvocation size(RelationshipPattern pattern) {
        return Functions.size(pattern);
    }

    public static FunctionInvocation exists(Expression expression) {
        return Functions.exists(expression);
    }

    public static FunctionInvocation distance(Expression point1, Expression point2) {
        return Functions.distance(point1, point2);
    }

    public static FunctionInvocation point(MapExpression parameterMap) {
        return Functions.point(parameterMap);
    }

    public static FunctionInvocation point(Expression expression) {
        return Functions.point(expression);
    }

    public static FunctionInvocation point(Parameter<?> parameter) {
        return Functions.point(parameter);
    }

    public static FunctionInvocation cartesian(double x, double y) {
        return Functions.cartesian(x, y);
    }

    public static FunctionInvocation coordinate(double longitude, double latitude) {
        return Functions.coordinate(longitude, latitude);
    }

    public static FunctionInvocation withinBBox(Expression point, Expression lowerLeft, Expression upperRight) {
        return Functions.withinBBox(point, lowerLeft, upperRight);
    }

    public static FunctionInvocation avg(Expression expression) {
        return Functions.avg(expression);
    }

    public static FunctionInvocation avgDistinct(Expression expression) {
        return Functions.avgDistinct(expression);
    }

    public static FunctionInvocation collect(Named variable) {
        return Functions.collect(variable);
    }

    public static FunctionInvocation collectDistinct(Named variable) {
        return Functions.collectDistinct(variable);
    }

    public static FunctionInvocation collect(Expression expression) {
        return Functions.collect(expression);
    }

    public static FunctionInvocation collectDistinct(Expression expression) {
        return Functions.collectDistinct(expression);
    }

    public static FunctionInvocation max(Expression expression) {
        return Functions.max(expression);
    }

    public static FunctionInvocation maxDistinct(Expression expression) {
        return Functions.maxDistinct(expression);
    }

    public static FunctionInvocation min(Expression expression) {
        return Functions.min(expression);
    }

    public static FunctionInvocation minDistinct(Expression expression) {
        return Functions.minDistinct(expression);
    }

    public static FunctionInvocation percentileCont(Expression expression, Number percentile) {
        return Functions.percentileCont(expression, percentile);
    }

    public static FunctionInvocation percentileContDistinct(Expression expression, Number percentile) {
        return Functions.percentileContDistinct(expression, percentile);
    }

    public static FunctionInvocation percentileDisc(Expression expression, Number percentile) {
        return Functions.percentileDisc(expression, percentile);
    }

    public static FunctionInvocation percentileDiscDistinct(Expression expression, Number percentile) {
        return Functions.percentileDiscDistinct(expression, percentile);
    }

    public static FunctionInvocation stDev(Expression expression) {
        return Functions.stDev(expression);
    }

    public static FunctionInvocation stDevDistinct(Expression expression) {
        return Functions.stDevDistinct(expression);
    }

    public static FunctionInvocation stDevP(Expression expression) {
        return Functions.stDevP(expression);
    }

    public static FunctionInvocation stDevPDistinct(Expression expression) {
        return Functions.stDevPDistinct(expression);
    }

    public static FunctionInvocation sum(Expression expression) {
        return Functions.sum(expression);
    }

    public static FunctionInvocation sumDistinct(Expression expression) {
        return Functions.sumDistinct(expression);
    }

    public static FunctionInvocation range(Integer start, Integer end) {
        return Functions.range(start, end);
    }

    public static FunctionInvocation range(Expression start, Expression end) {
        return Functions.range(start, end);
    }

    public static FunctionInvocation range(Integer start, Integer end, Integer step) {
        return Functions.range(start, end, step);
    }

    public static FunctionInvocation range(Expression start, Expression end, Expression step) {
        return Functions.range(start, end, step);
    }

    public static FunctionInvocation head(Expression expression) {
        return Functions.head(expression);
    }

    public static FunctionInvocation last(Expression expression) {
        return Functions.last(expression);
    }

    public static FunctionInvocation nodes(NamedPath path) {
        return Functions.nodes(path);
    }

    public static FunctionInvocation nodes(SymbolicName symbolicName) {
        return Functions.nodes(symbolicName);
    }

    public static FunctionInvocation relationships(NamedPath path) {
        return Functions.relationships(path);
    }

    public static FunctionInvocation relationships(SymbolicName symbolicName) {
        return Functions.relationships(symbolicName);
    }

    public static FunctionInvocation startNode(Relationship relationship) {
        return Functions.startNode(relationship);
    }

    public static FunctionInvocation endNode(Relationship relationship) {
        return Functions.endNode(relationship);
    }

    public static FunctionInvocation date() {
        return Functions.date();
    }

    public static FunctionInvocation calendarDate(Integer year, Integer month, Integer day) {
        return Functions.calendarDate(year, month, day);
    }

    public static FunctionInvocation weekDate(Integer year, Integer week, Integer dayOfWeek) {
        return Functions.weekDate(year, week, dayOfWeek);
    }

    public static FunctionInvocation quarterDate(Integer year, Integer quarter, Integer dayOfQuarter) {
        return Functions.quarterDate(year, quarter, dayOfQuarter);
    }

    public static FunctionInvocation ordinalDate(Integer year, Integer ordinalDay) {
        return Functions.ordinalDate(year, ordinalDay);
    }

    public static FunctionInvocation date(MapExpression components) {
        return Functions.date(components);
    }

    public static FunctionInvocation date(String temporalValue) {
        return Functions.date(temporalValue);
    }

    public static FunctionInvocation date(Expression temporalValue) {
        return Functions.date(temporalValue);
    }

    public static FunctionInvocation datetime() {
        return Functions.datetime();
    }

    public static FunctionInvocation datetime(TimeZone timeZone) {
        return Functions.datetime(timeZone);
    }

    public static FunctionInvocation datetime(MapExpression components) {
        return Functions.datetime(components);
    }

    public static FunctionInvocation datetime(String temporalValue) {
        return Functions.datetime(temporalValue);
    }

    public static FunctionInvocation datetime(Expression temporalValue) {
        return Functions.datetime(temporalValue);
    }

    public static FunctionInvocation localdatetime() {
        return Functions.localdatetime();
    }

    public static FunctionInvocation localdatetime(TimeZone timeZone) {
        return Functions.localdatetime(timeZone);
    }

    public static FunctionInvocation localdatetime(MapExpression components) {
        return Functions.localdatetime(components);
    }

    public static FunctionInvocation localdatetime(String temporalValue) {
        return Functions.localdatetime(temporalValue);
    }

    public static FunctionInvocation localdatetime(Expression temporalValue) {
        return Functions.localdatetime(temporalValue);
    }

    public static FunctionInvocation localtime() {
        return Functions.localtime();
    }

    public static FunctionInvocation localtime(TimeZone timeZone) {
        return Functions.localtime(timeZone);
    }

    public static FunctionInvocation localtime(MapExpression components) {
        return Functions.localtime(components);
    }

    public static FunctionInvocation localtime(String temporalValue) {
        return Functions.localtime(temporalValue);
    }

    public static FunctionInvocation localtime(Expression temporalValue) {
        return Functions.localtime(temporalValue);
    }

    public static FunctionInvocation time() {
        return Functions.time();
    }

    public static FunctionInvocation time(TimeZone timeZone) {
        return Functions.time(timeZone);
    }

    public static FunctionInvocation time(MapExpression components) {
        return Functions.time(components);
    }

    public static FunctionInvocation time(String temporalValue) {
        return Functions.time(temporalValue);
    }

    public static FunctionInvocation time(Expression temporalValue) {
        return Functions.time(temporalValue);
    }

    public static FunctionInvocation duration(MapExpression components) {
        return Functions.duration(components);
    }

    public static FunctionInvocation duration(String temporalAmount) {
        return Functions.duration(temporalAmount);
    }

    public static FunctionInvocation duration(Expression temporalAmount) {
        return Functions.duration(temporalAmount);
    }

    public static Reduction.OngoingDefinitionWithVariable reduce(SymbolicName variable) {
        return Functions.reduce(variable);
    }

    public static FunctionInvocation abs(Expression expression) {
        return Functions.abs(expression);
    }

    public static FunctionInvocation ceil(Expression expression) {
        return Functions.ceil(expression);
    }

    public static FunctionInvocation floor(Expression expression) {
        return Functions.floor(expression);
    }

    public static FunctionInvocation rand() {
        return Functions.rand();
    }

    public static FunctionInvocation round(Expression value, Expression ... expression) {
        return Functions.round(value, expression);
    }

    public static FunctionInvocation sign(Expression expression) {
        return Functions.sign(expression);
    }

    public static FunctionInvocation e() {
        return Functions.e();
    }

    public static FunctionInvocation exp(Expression expression) {
        return Functions.exp(expression);
    }

    public static FunctionInvocation log(Expression expression) {
        return Functions.log(expression);
    }

    public static FunctionInvocation log10(Expression expression) {
        return Functions.log10(expression);
    }

    public static FunctionInvocation sqrt(Expression expression) {
        return Functions.sqrt(expression);
    }

    public static FunctionInvocation acos(Expression expression) {
        return Functions.acos(expression);
    }

    public static FunctionInvocation asin(Expression expression) {
        return Functions.asin(expression);
    }

    public static FunctionInvocation atan(Expression expression) {
        return Functions.atan(expression);
    }

    public static FunctionInvocation atan2(Expression y, Expression x) {
        return Functions.atan2(y, x);
    }

    public static FunctionInvocation cos(Expression expression) {
        return Functions.cos(expression);
    }

    public static FunctionInvocation cot(Expression expression) {
        return Functions.cot(expression);
    }

    public static FunctionInvocation degrees(Expression expression) {
        return Functions.degrees(expression);
    }

    public static FunctionInvocation haversin(Expression expression) {
        return Functions.haversin(expression);
    }

    public static FunctionInvocation pi() {
        return Functions.pi();
    }

    public static FunctionInvocation radians(Expression expression) {
        return Functions.radians(expression);
    }

    public static FunctionInvocation sin(Expression expression) {
        return Functions.sin(expression);
    }

    public static FunctionInvocation tan(Expression expression) {
        return Functions.tan(expression);
    }

    public static FunctionInvocation toInteger(Expression expression) {
        return Functions.toInteger(expression);
    }

    public static FunctionInvocation toString(Expression expression) {
        return Functions.toString(expression);
    }

    public static FunctionInvocation toStringOrNull(Expression expression) {
        return Functions.toStringOrNull(expression);
    }

    public static FunctionInvocation toFloat(Expression expression) {
        return Functions.toFloat(expression);
    }

    public static FunctionInvocation toBoolean(Expression expression) {
        return Functions.toBoolean(expression);
    }

    public static FunctionInvocation linenumber() {
        return Functions.linenumber();
    }

    public static FunctionInvocation file() {
        return Functions.file();
    }

    public static FunctionInvocation randomUUID() {
        return Functions.randomUUID();
    }

    public static FunctionInvocation length(NamedPath path) {
        return Functions.length(path);
    }

    @Neo4jVersion(minimum="5.0.0")
    public static FunctionInvocation graphNames() {
        return Functions.graphNames();
    }

    @Neo4jVersion(minimum="5.0.0")
    public static FunctionInvocation graphPropertiesByName(Expression name) {
        return Functions.graphPropertiesByName(name);
    }

    @Neo4jVersion(minimum="5.0.0")
    public static FunctionInvocation graphByName(Expression name) {
        return Functions.graphByName(name);
    }

    public static MapProjection createProjection(SymbolicName name, Object ... content) {
        return MapProjection.create(name, content);
    }

    public static Operation minus(Expression e) {
        return Operations.minus(e);
    }

    public static Expression plus(Expression e) {
        return Operations.plus(e);
    }

    public static Operation concat(Expression op1, Expression op2) {
        return Operations.concat(op1, op2);
    }

    public static Operation add(Expression op1, Expression op2) {
        return Operations.add(op1, op2);
    }

    public static Operation subtract(Expression op1, Expression op2) {
        return Operations.subtract(op1, op2);
    }

    public static Operation multiply(Expression op1, Expression op2) {
        return Operations.multiply(op1, op2);
    }

    public static Operation divide(Expression op1, Expression op2) {
        return Operations.divide(op1, op2);
    }

    public static Operation remainder(Expression op1, Expression op2) {
        return Operations.remainder(op1, op2);
    }

    public static Operation pow(Expression op1, Expression op2) {
        return Operations.pow(op1, op2);
    }

    public static Operation set(Expression target, Expression value) {
        return Operations.set(target, value);
    }

    public static Operation mutate(Expression target, MapExpression value) {
        return Operations.mutate(target, value);
    }

    public static Operation mutate(Expression target, Expression value) {
        return Operations.mutate(target, value);
    }

    public static Operation setLabel(Node target, String ... label) {
        return Operations.set(target, label);
    }

    public static Operation setLabel(Node target, Labels label) {
        return Operations.set(target, label);
    }

    public static Operation removeLabel(Node target, String ... label) {
        return Operations.remove(target, label);
    }

    public static Condition exists(Property property) {
        return Predicates.exists(property);
    }

    public static Condition exists(RelationshipPattern pattern) {
        return Predicates.exists(pattern);
    }

    public static Condition exists(Statement statement, IdentifiableElement ... imports) {
        return Predicates.exists(statement, imports);
    }

    public static Condition exists(PatternElement pattern) {
        return Predicates.exists(pattern);
    }

    public static Condition exists(List<PatternElement> pattern) {
        return Predicates.exists(pattern);
    }

    public static Condition exists(List<PatternElement> pattern, Where where) {
        return Predicates.exists(pattern, where);
    }

    public static OngoingListBasedPredicateFunction all(String variable) {
        return Predicates.all(variable);
    }

    public static OngoingListBasedPredicateFunction all(SymbolicName variable) {
        return Predicates.all(variable);
    }

    public static OngoingListBasedPredicateFunction any(String variable) {
        return Predicates.any(variable);
    }

    public static OngoingListBasedPredicateFunction any(SymbolicName variable) {
        return Predicates.any(variable);
    }

    public static OngoingListBasedPredicateFunction none(String variable) {
        return Predicates.none(variable);
    }

    public static OngoingListBasedPredicateFunction none(SymbolicName variable) {
        return Predicates.none(variable);
    }

    public static OngoingListBasedPredicateFunction single(String variable) {
        return Predicates.single(variable);
    }

    public static OngoingListBasedPredicateFunction single(SymbolicName variable) {
        return Predicates.single(variable);
    }
}

