/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Comparison;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExpressionCondition;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.InternalPropertyImpl;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyAccessor;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public interface Expression
extends Visitable,
PropertyAccessor {
    default public Condition includesAll(Expression rhs) {
        return Conditions.includesAll(this, rhs);
    }

    default public Condition includesAny(Expression rhs) {
        return Conditions.includesAny(this, rhs);
    }

    default public AliasedExpression as(String alias) {
        Assertions.hasText(alias, "The alias may not be null or empty.");
        return new AliasedExpression(this, alias);
    }

    default public Expression size() {
        return Functions.size(this);
    }

    default public Condition hasSize(Expression expectedSize) {
        return Functions.size(this).isEqualTo(expectedSize);
    }

    default public AliasedExpression as(SymbolicName alias) {
        Assertions.notNull(alias, "The alias may not be null.");
        return this.as(alias.getValue());
    }

    default public Condition asCondition() {
        Condition condition;
        Expression expression = this;
        if (expression instanceof Condition) {
            Condition condition2 = (Condition)expression;
            condition = condition2;
        } else {
            condition = new ExpressionCondition(this);
        }
        return condition;
    }

    default public Condition isEqualTo(Expression rhs) {
        return Conditions.isEqualTo(this, rhs);
    }

    default public Condition eq(Expression rhs) {
        return this.isEqualTo(rhs);
    }

    default public Condition isNotEqualTo(Expression rhs) {
        return Conditions.isNotEqualTo(this, rhs);
    }

    default public Condition ne(Expression rhs) {
        return this.isNotEqualTo(rhs);
    }

    default public Condition lt(Expression rhs) {
        return Conditions.lt(this, rhs);
    }

    default public Condition lte(Expression rhs) {
        return Conditions.lte(this, rhs);
    }

    default public Condition gt(Expression rhs) {
        return Conditions.gt(this, rhs);
    }

    default public Condition gte(Expression rhs) {
        return Conditions.gte(this, rhs);
    }

    default public Condition isTrue() {
        return Conditions.isEqualTo(this, Cypher.literalTrue());
    }

    default public Condition isFalse() {
        return Conditions.isEqualTo(this, Cypher.literalFalse());
    }

    default public Condition matches(Expression expression) {
        return Conditions.matches(this, expression);
    }

    default public Condition matches(String pattern) {
        return Conditions.matches(this, Cypher.literalOf(pattern));
    }

    default public Condition startsWith(Expression expression) {
        return Conditions.startsWith(this, expression);
    }

    default public Condition contains(Expression expression) {
        return Conditions.contains(this, expression);
    }

    default public Condition endsWith(Expression expression) {
        return Conditions.endsWith(this, expression);
    }

    default public Operation concat(Expression expression) {
        return Operations.concat(this, expression);
    }

    default public Operation add(Expression addend) {
        return Operations.add(this, addend);
    }

    default public Operation subtract(Expression subtrahend) {
        return Operations.subtract(this, subtrahend);
    }

    default public Operation multiply(Expression multiplicand) {
        return Operations.multiply(this, multiplicand);
    }

    default public Operation divide(Expression dividend) {
        return Operations.divide(this, dividend);
    }

    default public Operation remainder(Expression dividend) {
        return Operations.remainder(this, dividend);
    }

    default public Operation pow(Expression n) {
        return Operations.pow(this, n);
    }

    default public Condition isNull() {
        return Conditions.isNull(this);
    }

    default public Condition isNotNull() {
        return Conditions.isNotNull(this);
    }

    default public Condition in(Expression haystack) {
        return Comparison.create(this, Operator.IN, haystack);
    }

    default public Condition isEmpty() {
        return Functions.size(this).isEqualTo(Cypher.literalOf(0L));
    }

    default public SortItem descending() {
        return SortItem.create(this, SortItem.Direction.DESC);
    }

    default public SortItem ascending() {
        return SortItem.create(this, SortItem.Direction.ASC);
    }

    default public SortItem sorted(SortItem.Direction direction) {
        return SortItem.create(this, direction);
    }

    @Override
    default public Property property(String ... names) {
        return InternalPropertyImpl.create(this, names);
    }

    @Override
    default public Property property(Expression lookup) {
        return InternalPropertyImpl.create(this, lookup);
    }
}

