/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Objects;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class Parameter<T>
implements Expression {
    static final Object NO_VALUE = new Object();
    private final String name;
    private final T value;

    private Parameter(String name, T value) {
        this.name = name;
        this.value = value;
    }

    static Parameter<Object> create(String name) {
        return Parameter.create(name, NO_VALUE);
    }

    static <T> Parameter<T> create(String name, T value) {
        Assertions.hasText(name, "The name of the parameter is required!");
        if (name.startsWith("$")) {
            return Parameter.create(name.substring(1), value);
        }
        return new Parameter<T>(name, value);
    }

    static <T> Parameter<T> anon(T value) {
        return new Parameter<T>(null, value);
    }

    @API(status=API.Status.STABLE, since="2021.0.0")
    public boolean isAnon() {
        return this.name == null || this.name.trim().isEmpty();
    }

    @API(status=API.Status.STABLE, since="2023.1.0")
    public String getName() {
        return this.name;
    }

    @API(status=API.Status.STABLE, since="2021.0.0")
    public Parameter<?> withValue(Object newValue) {
        return Parameter.create(this.name, newValue);
    }

    @API(status=API.Status.INTERNAL, since="2021.1.0")
    public T getValue() {
        return this.value;
    }

    boolean hasValue() {
        return !Objects.equals(this.value, NO_VALUE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.isAnon() && parameter.isAnon()) {
            return Objects.deepEquals(this.value, parameter.value);
        }
        if (this.isAnon() != parameter.isAnon()) {
            return false;
        }
        return Objects.equals(this.name, parameter.name);
    }

    public int hashCode() {
        return this.isAnon() ? Objects.hashCode(this.value) : Objects.hash(this.name);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

