/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractStatement;
import org.neo4j.cypherdsl.core.Arguments;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.ProcedureName;
import org.neo4j.cypherdsl.core.internal.YieldItems;

@API(status=API.Status.INTERNAL, since="2021.2.1")
class ProcedureCallImpl
extends AbstractStatement
implements ProcedureCall {
    private final ProcedureName name;
    private final Arguments arguments;
    private final YieldItems yieldItems;
    private final Where optionalWhere;

    private ProcedureCallImpl(ProcedureName name, Arguments arguments, YieldItems yieldItems, Where optionalWhere) {
        this.name = name;
        this.arguments = arguments != null ? arguments : new Arguments(new Expression[0]);
        this.yieldItems = yieldItems;
        this.optionalWhere = optionalWhere;
    }

    static ProcedureCall create(ProcedureName name, Arguments arguments, YieldItems yieldItems, Where optionalWhere) {
        if (yieldItems != null) {
            return new ProcedureCallImplWithResult(name, arguments, yieldItems, optionalWhere);
        }
        return new ProcedureCallImpl(name, arguments, null, optionalWhere);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.name.accept(visitor);
        Visitable.visitIfNotNull(this.arguments, visitor);
        Visitable.visitIfNotNull(this.yieldItems, visitor);
        Visitable.visitIfNotNull(this.optionalWhere, visitor);
        visitor.leave(this);
    }

    static final class ProcedureCallImplWithResult
    extends ProcedureCallImpl
    implements ResultStatement {
        private ProcedureCallImplWithResult(ProcedureName name, Arguments arguments, YieldItems yieldItems, Where optionalWhere) {
            super(name, arguments, yieldItems, optionalWhere);
        }
    }
}

