/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.internal;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Clause;

@API(status=API.Status.INTERNAL, since="2021.2.1")
public final class LoadCSV
implements Clause {
    private final URI uri;
    private final boolean withHeaders;
    private final String alias;
    private final String fieldTerminator;

    public LoadCSV(URI uri, boolean withHeaders, String alias) {
        this(uri, withHeaders, alias, null);
    }

    private LoadCSV(URI uri, boolean withHeaders, String alias, String fieldTerminator) {
        this.uri = uri;
        this.withHeaders = withHeaders;
        this.alias = alias;
        this.fieldTerminator = fieldTerminator;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean isWithHeaders() {
        return this.withHeaders;
    }

    public String getFieldTerminator() {
        return this.fieldTerminator;
    }

    public String getAlias() {
        return this.alias;
    }

    public LoadCSV withFieldTerminator(String newFieldTerminator) {
        String value = Optional.ofNullable(newFieldTerminator).map(String::trim).filter(v -> !v.isEmpty()).orElse(null);
        if (Objects.equals(this.fieldTerminator, value)) {
            return this;
        }
        return new LoadCSV(this.uri, this.withHeaders, this.alias, value);
    }
}

