/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.summary.InternalGqlStatusObject;
import org.neo4j.driver.summary.GqlNotification;
import org.neo4j.driver.summary.InputPosition;

public final class InternalGqlNotification
extends InternalGqlStatusObject
implements GqlNotification {
    private final InputPosition position;
    private final NotificationSeverity severityLevel;
    private final String rawSeverityLevel;
    private final NotificationClassification classification;
    private final String rawClassification;
    private final String code;
    private final String title;
    private final String description;

    public InternalGqlNotification(String gqlStatus, String statusDescription, Map<String, Value> diagnosticRecord, InputPosition position, NotificationSeverity severityLevel, String rawSeverityLevel, NotificationClassification classification, String rawClassification, String code, String title, String description) {
        super(gqlStatus, statusDescription, diagnosticRecord);
        this.position = position;
        this.severityLevel = severityLevel;
        this.rawSeverityLevel = rawSeverityLevel;
        this.classification = classification;
        this.rawClassification = rawClassification;
        this.code = code;
        this.title = title;
        this.description = description;
    }

    @Override
    public Optional<InputPosition> position() {
        return Optional.ofNullable(this.position);
    }

    @Override
    public Optional<NotificationSeverity> severity() {
        return Optional.ofNullable(this.severityLevel);
    }

    @Override
    public Optional<String> rawSeverity() {
        return Optional.ofNullable(this.rawSeverityLevel);
    }

    @Override
    public Optional<NotificationClassification> classification() {
        return Optional.ofNullable(this.classification);
    }

    @Override
    public Optional<String> rawClassification() {
        return Optional.ofNullable(this.rawClassification);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalGqlNotification that = (InternalGqlNotification)o;
        return Objects.equals(this.gqlStatus, that.gqlStatus) && Objects.equals(this.statusDescription, that.statusDescription) && Objects.equals(this.diagnosticRecord, that.diagnosticRecord) && Objects.equals(this.code, that.code) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.gqlStatus, this.statusDescription, this.diagnosticRecord, this.code, this.title, this.description);
    }

    @Override
    public String toString() {
        return "InternalGqlNotification{gqlStatus='" + this.gqlStatus + "', statusDescription='" + this.statusDescription + "', diagnosticRecord=" + String.valueOf(this.diagnosticRecord) + "', code='" + this.code + "', title='" + this.title + "', description='" + this.description + "}";
    }

    public String code() {
        return this.code;
    }

    public String title() {
        return this.title;
    }

    public String description() {
        return this.description;
    }
}

