/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Labels;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NodeBase;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class InternalNodeImpl
extends NodeBase<InternalNodeImpl> {
    InternalNodeImpl() {
    }

    InternalNodeImpl(Labels labelExpression, Where innerPredicate) {
        super(null, null, labelExpression, null, innerPredicate);
    }

    InternalNodeImpl(String primaryLabel, String ... additionalLabels) {
        super(primaryLabel, additionalLabels);
    }

    InternalNodeImpl(SymbolicName symbolicName, List<NodeLabel> labels, Labels labelExpression, Properties properties, Where innerPredicate) {
        super(symbolicName, labels, labelExpression, properties, innerPredicate);
    }

    InternalNodeImpl(SymbolicName symbolicName, String primaryLabel, MapExpression properties, String ... additionalLabels) {
        super(symbolicName, primaryLabel, properties, additionalLabels);
    }

    @Override
    public InternalNodeImpl named(SymbolicName newSymbolicName) {
        Assertions.notNull(newSymbolicName, "Symbolic name is required.");
        return new InternalNodeImpl(newSymbolicName, this.staticLabels, this.dynamicLabels, this.properties, this.innerPredicate);
    }

    @Override
    public InternalNodeImpl withProperties(MapExpression newProperties) {
        return new InternalNodeImpl((SymbolicName)this.getSymbolicName().orElse(null), this.staticLabels, this.dynamicLabels, Properties.create(newProperties), this.innerPredicate);
    }

    @Override
    public Node where(Expression predicate) {
        if (predicate == null) {
            return this;
        }
        return new InternalNodeImpl((SymbolicName)this.getSymbolicName().orElse(null), this.staticLabels, this.dynamicLabels, this.properties, Where.from(predicate));
    }
}

