/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.factory;

import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.collection.HeapTrackingObjectMap;
import org.neo4j.collection.diffset.MutableLongDiffSets;
import org.neo4j.collection.diffset.TrackableDiffSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;

public class OnHeapCollectionsFactory
implements CollectionsFactory {
    public static final CollectionsFactory INSTANCE = new OnHeapCollectionsFactory();

    private OnHeapCollectionsFactory() {
    }

    @Override
    public MutableLongSet newLongSet(MemoryTracker memoryTracker) {
        return HeapTrackingCollections.newLongSet(memoryTracker);
    }

    @Override
    public MutableIntSet newIntSet(MemoryTracker memoryTracker) {
        return HeapTrackingCollections.newIntSet(memoryTracker);
    }

    @Override
    public MutableLongDiffSets newLongDiffSets(MemoryTracker memoryTracker) {
        return TrackableDiffSets.newMutableLongDiffSets(this, memoryTracker);
    }

    @Override
    public <T extends Measurable> MutableLongObjectMap<T> newObjectMap(MemoryTracker memoryTracker) {
        return HeapTrackingObjectMap.createObjectMap(memoryTracker);
    }

    @Override
    public void release() {
    }
}

