/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class HeapTrackingUnifiedSet<T>
extends UnifiedSet<T>
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingUnifiedSet.class);
    private static final long SHALLOW_SIZE_OF_CHAINED_BUCKET = HeapEstimator.shallowSizeOfInstance(SimulatedChainedBucket.class);
    private final MemoryTracker memoryTracker;
    private long trackedHeap;

    public static <T> HeapTrackingUnifiedSet<T> createUnifiedSet(MemoryTracker memoryTracker) {
        int initialSizeToAllocate = 16;
        long trackedHeap = HeapTrackingUnifiedSet.arrayHeapSize(initialSizeToAllocate);
        memoryTracker.allocateHeap(SHALLOW_SIZE + trackedHeap);
        return new HeapTrackingUnifiedSet<T>(memoryTracker, trackedHeap);
    }

    public static <T> HeapTrackingUnifiedSet<T> createUnifiedSet(MemoryTracker memoryTracker, Iterable<T> elements) {
        HeapTrackingUnifiedSet<T> set = HeapTrackingUnifiedSet.createUnifiedSet(memoryTracker);
        set.addAllIterable(elements);
        return set;
    }

    private HeapTrackingUnifiedSet(MemoryTracker memoryTracker, long trackedHeap) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedHeap = trackedHeap;
    }

    public boolean addAllIterable(Iterable<? extends T> iterable) {
        if (iterable instanceof UnifiedSet) {
            int size;
            UnifiedSet unifiedSet = (UnifiedSet)iterable;
            if (this.size() == 0 && (size = unifiedSet.size()) > this.maxSize) {
                int newCapacity = this.fastCeil((float)size / this.loadFactor);
                this.init(newCapacity);
                this.allocateEstimatedHeapUsageForChains();
            }
        }
        return super.addAllIterable(iterable);
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            long heapToAllocate = HeapTrackingUnifiedSet.arrayHeapSize(sizeToAllocate);
            this.memoryTracker.allocateHeap(heapToAllocate);
            this.memoryTracker.releaseHeap(this.trackedHeap);
            this.trackedHeap = heapToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    protected void rehash(int newCapacity) {
        super.rehash(newCapacity);
        this.allocateEstimatedHeapUsageForChains();
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(SHALLOW_SIZE + this.trackedHeap);
    }

    private void allocateEstimatedHeapUsageForChains() {
        double minEstimatedCollidingBucketFraction = 0.15;
        double maxEstimatedCollidingBucketFraction = 0.23;
        double minMultipleBucketFactor = 1.001;
        double maxMultipleBucketFactor = 1.007;
        double overestimationWeight = 0.57;
        int maxSize = this.maxSize;
        double minSizeBeforeNextRehash = (maxSize >> 1) + 1;
        double maxSizeBeforeNextRehash = maxSize;
        double minEstimatedNumberOfChains = minSizeBeforeNextRehash * minEstimatedCollidingBucketFraction * minMultipleBucketFactor;
        double maxEstimatedNumberOfChains = maxSizeBeforeNextRehash * maxEstimatedCollidingBucketFraction * maxMultipleBucketFactor;
        long estimatedNumberOfChains = (long)Math.ceil((1.0 - overestimationWeight) * minEstimatedNumberOfChains + overestimationWeight * maxEstimatedNumberOfChains);
        long estimatedHeapUsageForChains = estimatedNumberOfChains * SHALLOW_SIZE_OF_CHAINED_BUCKET;
        this.memoryTracker.allocateHeap(estimatedHeapUsageForChains);
        this.trackedHeap += estimatedHeapUsageForChains;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    @VisibleForTesting
    public static long arrayHeapSize(int arrayLength) {
        return HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * (long)HeapEstimator.OBJECT_REFERENCE_BYTES));
    }

    private static final class SimulatedChainedBucket {
        private Object zero;
        private Object one;
        private Object two;
        private Object three;

        private SimulatedChainedBucket() {
        }
    }
}

