/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.prettifier;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.neo4j.cypher.internal.ast.ActionResourceBase;
import org.neo4j.cypher.internal.ast.AllDatabasesQualifier;
import org.neo4j.cypher.internal.ast.AllDatabasesScope;
import org.neo4j.cypher.internal.ast.AllGraphsScope;
import org.neo4j.cypher.internal.ast.AllLabelResource;
import org.neo4j.cypher.internal.ast.AllPropertyResource;
import org.neo4j.cypher.internal.ast.AllQualifier;
import org.neo4j.cypher.internal.ast.DatabaseName;
import org.neo4j.cypher.internal.ast.DatabaseScope;
import org.neo4j.cypher.internal.ast.DefaultDatabaseScope;
import org.neo4j.cypher.internal.ast.Element;
import org.neo4j.cypher.internal.ast.ElementQualifier;
import org.neo4j.cypher.internal.ast.ElementsAllQualifier;
import org.neo4j.cypher.internal.ast.FunctionAllQualifier;
import org.neo4j.cypher.internal.ast.FunctionQualifier;
import org.neo4j.cypher.internal.ast.GraphAction;
import org.neo4j.cypher.internal.ast.GraphScope;
import org.neo4j.cypher.internal.ast.HomeDatabaseScope;
import org.neo4j.cypher.internal.ast.HomeGraphScope;
import org.neo4j.cypher.internal.ast.LabelAllQualifier;
import org.neo4j.cypher.internal.ast.LabelQualifier;
import org.neo4j.cypher.internal.ast.LabelResource;
import org.neo4j.cypher.internal.ast.LabelsResource;
import org.neo4j.cypher.internal.ast.LoadAllQualifier;
import org.neo4j.cypher.internal.ast.LoadCidrQualifier;
import org.neo4j.cypher.internal.ast.LoadUrlQualifier;
import org.neo4j.cypher.internal.ast.NamedDatabasesScope;
import org.neo4j.cypher.internal.ast.NamedGraphsScope;
import org.neo4j.cypher.internal.ast.NamespacedName;
import org.neo4j.cypher.internal.ast.NoOptions$;
import org.neo4j.cypher.internal.ast.Node$;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.ast.OptionsMap;
import org.neo4j.cypher.internal.ast.OptionsParam;
import org.neo4j.cypher.internal.ast.ParameterName;
import org.neo4j.cypher.internal.ast.PatternQualifier;
import org.neo4j.cypher.internal.ast.PrivilegeQualifier;
import org.neo4j.cypher.internal.ast.ProcedureAllQualifier;
import org.neo4j.cypher.internal.ast.ProcedureQualifier;
import org.neo4j.cypher.internal.ast.PropertiesResource;
import org.neo4j.cypher.internal.ast.PropertyResource;
import org.neo4j.cypher.internal.ast.Relationship$;
import org.neo4j.cypher.internal.ast.RelationshipAllQualifier;
import org.neo4j.cypher.internal.ast.RelationshipQualifier;
import org.neo4j.cypher.internal.ast.SettingAllQualifier;
import org.neo4j.cypher.internal.ast.SettingQualifier;
import org.neo4j.cypher.internal.ast.ShardDefinition;
import org.neo4j.cypher.internal.ast.ShowAllPrivileges;
import org.neo4j.cypher.internal.ast.ShowPrivilegeScope;
import org.neo4j.cypher.internal.ast.ShowRolesPrivileges;
import org.neo4j.cypher.internal.ast.ShowUserPrivileges;
import org.neo4j.cypher.internal.ast.ShowUsersPrivileges;
import org.neo4j.cypher.internal.ast.SingleNamedDatabaseScope;
import org.neo4j.cypher.internal.ast.SingleNamedGraphScope;
import org.neo4j.cypher.internal.ast.Topology;
import org.neo4j.cypher.internal.ast.UserAllQualifier;
import org.neo4j.cypher.internal.ast.UserQualifier;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier$EmptyExtension$;
import org.neo4j.cypher.internal.expressions.Equals;
import org.neo4j.cypher.internal.expressions.ExplicitParameter;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.GreaterThan;
import org.neo4j.cypher.internal.expressions.GreaterThanOrEqual;
import org.neo4j.cypher.internal.expressions.In;
import org.neo4j.cypher.internal.expressions.IsNotNull;
import org.neo4j.cypher.internal.expressions.IsNull;
import org.neo4j.cypher.internal.expressions.LessThan;
import org.neo4j.cypher.internal.expressions.LessThanOrEqual;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.MapExpression;
import org.neo4j.cypher.internal.expressions.Not;
import org.neo4j.cypher.internal.expressions.NotEquals;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.util.Stringifier;
import scala.DummyImplicit;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Prettifier$
implements Serializable {
    public static final Prettifier$ MODULE$ = new Prettifier$();
    private static final PartialFunction<Expression, String> escapeName = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            A1 A1 = x1;
            if (A1 instanceof StringLiteral) {
                StringLiteral stringLiteral = (StringLiteral)A1;
                String s = stringLiteral.value();
                return (B1)Stringifier.backtickEmpty((String)s);
            }
            if (A1 instanceof Variable) {
                Variable variable = (Variable)A1;
                String v = variable.name();
                return (B1)Stringifier.backtickEmpty((String)v);
            }
            if (A1 instanceof Parameter) {
                Parameter parameter = (Parameter)A1;
                return (B1)("$" + Stringifier.backtickEmpty((String)parameter.name()));
            }
            return (B1)function1.apply(x1);
        }

        public final boolean isDefinedAt(Expression x1) {
            Expression expression = x1;
            if (expression instanceof StringLiteral) {
                return true;
            }
            if (expression instanceof Variable) {
                return true;
            }
            return expression instanceof Parameter;
        }
    };

    public Prettifier.ClausePrettifier $lessinit$greater$default$2() {
        return Prettifier$EmptyExtension$.MODULE$;
    }

    public boolean $lessinit$greater$default$3() {
        return true;
    }

    public String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$prettifyRename(String commandName, Expression fromName, Expression toName, boolean ifExists) {
        String maybeIfExists = ifExists ? " IF EXISTS" : "";
        return commandName + " " + this.escapeName().apply((Object)fromName) + maybeIfExists + " TO " + this.escapeName().apply((Object)toName);
    }

    public String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$extractScope(ShowPrivilegeScope scope) {
        ShowPrivilegeScope showPrivilegeScope = scope;
        if (showPrivilegeScope instanceof ShowUserPrivileges) {
            ShowUserPrivileges showUserPrivileges = (ShowUserPrivileges)showPrivilegeScope;
            Option<Expression> name = showUserPrivileges.user();
            if (name.isDefined()) {
                return "USER " + this.escapeName().apply(name.get());
            }
            return "USER";
        }
        if (showPrivilegeScope instanceof ShowUsersPrivileges) {
            ShowUsersPrivileges showUsersPrivileges = (ShowUsersPrivileges)showPrivilegeScope;
            List<Expression> names = showUsersPrivileges.users();
            if (names.size() == 1) {
                return "USER " + this.escapeName().apply(names.head());
            }
            return "USERS " + this.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$escapeNames((Seq<Expression>)names);
        }
        if (showPrivilegeScope instanceof ShowRolesPrivileges) {
            ShowRolesPrivileges showRolesPrivileges = (ShowRolesPrivileges)showPrivilegeScope;
            List<Expression> names = showRolesPrivileges.roles();
            if (names.size() == 1) {
                return "ROLE " + this.escapeName().apply(names.head());
            }
            return "ROLES " + this.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$escapeNames((Seq<Expression>)names);
        }
        if (showPrivilegeScope instanceof ShowAllPrivileges) {
            return "ALL";
        }
        return "<unknown>";
    }

    public String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$prettifyDatabasePrivilege(String privilegeName, DatabaseScope dbScope, List<PrivilegeQualifier> qualifier, String preposition, Seq<Expression> roleNames) {
        Tuple3<String, Object, Object> tuple3 = this.extractDbScope(dbScope);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String dbName = (String)tuple3._1();
        boolean home = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        boolean multiple = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)dbName, (Object)BoxesRunTime.boxToBoolean((boolean)home), (Object)BoxesRunTime.boxToBoolean((boolean)multiple));
        String dbName2 = (String)tuple32._1();
        boolean home2 = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
        boolean multiple2 = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
        String db = home2 ? dbName2 + " DATABASE" : (multiple2 ? "DATABASES " + dbName2 : "DATABASE " + dbName2);
        return privilegeName + this.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$extractQualifierString(qualifier) + " ON " + db + " " + preposition + " " + this.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$escapeNames(roleNames);
    }

    /*
     * Unable to fully structure code
     */
    public String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$prettifyGraphPrivilege(String privilegeName, GraphScope graphScope, String qualifierString, Option<ActionResourceBase> resource, String preposition, Seq<Expression> roleNames) {
        var9_7 = false;
        var10_8 = null;
        var11_9 = resource;
        if (!(var11_9 instanceof Some)) ** GOTO lbl-1000
        var9_7 = true;
        var10_8 = (Some)var11_9;
        var12_10 = (ActionResourceBase)var10_8.value();
        if (var12_10 instanceof PropertyResource) {
            var13_11 = (PropertyResource)var12_10;
            name = var13_11.property();
            v0 = " {" + Stringifier.backtickEmpty((String)name) + "}";
        } else if (var9_7 && (var15_13 = (ActionResourceBase)var10_8.value()) instanceof PropertiesResource) {
            var16_14 = (PropertiesResource)var15_13;
            names = var16_14.properties();
            v0 = " {" + ((IterableOnceOps)names.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$prettifyGraphPrivilege$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)())).mkString(", ") + "}";
        } else if (var9_7 && (var18_16 = (ActionResourceBase)var10_8.value()) instanceof AllPropertyResource) {
            v0 = " {*}";
        } else if (var9_7 && (var19_17 = (ActionResourceBase)var10_8.value()) instanceof LabelResource) {
            var20_18 = (LabelResource)var19_17;
            name = var20_18.label();
            v0 = " " + Stringifier.backtickEmpty((String)name);
        } else if (var9_7 && (var22_20 = (ActionResourceBase)var10_8.value()) instanceof LabelsResource) {
            var23_21 = (LabelsResource)var22_20;
            names = var23_21.labels();
            v0 = " " + ((IterableOnceOps)names.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$prettifyGraphPrivilege$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)())).mkString(", ");
        } else if (var9_7 && (var25_23 = (ActionResourceBase)var10_8.value()) instanceof AllLabelResource) {
            v0 = " *";
        } else if (None$.MODULE$.equals(var11_9)) {
            v0 = "";
        } else {
            throw new IllegalStateException("Unknown resource: " + resource);
        }
        resourceName = v0;
        scope = String.valueOf(this.extractGraphScope(graphScope));
        return privilegeName + resourceName + " ON " + scope + qualifierString + " " + preposition + " " + this.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$escapeNames(roleNames);
    }

    public PartialFunction<List<PrivilegeQualifier>, String> org$neo4j$cypher$internal$ast$prettifier$Prettifier$$prettifyLoadPrivilegeQualifier(ExpressionStringifier expr) {
        return new Serializable(expr){
            private static final long serialVersionUID = 0L;
            private final ExpressionStringifier expr$1;

            public final <A1 extends List<PrivilegeQualifier>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                .colon.colon colon2 = null;
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)A1;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadAllQualifier && Nil$.MODULE$.equals(list)) {
                        return (B1)"ALL DATA";
                    }
                }
                if (bl) {
                    LoadUrlQualifier loadUrlQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadUrlQualifier && (either = (loadUrlQualifier = (LoadUrlQualifier)privilegeQualifier).url()) instanceof Left) {
                        Left left = (Left)either;
                        String urlString = (String)left.value();
                        if (Nil$.MODULE$.equals(list)) {
                            return (B1)("URL " + this.expr$1.quote(urlString));
                        }
                    }
                }
                if (bl) {
                    LoadUrlQualifier loadUrlQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadUrlQualifier && (either = (loadUrlQualifier = (LoadUrlQualifier)privilegeQualifier).url()) instanceof Right) {
                        Right right = (Right)either;
                        Parameter urlParam = (Parameter)right.value();
                        if (Nil$.MODULE$.equals(list)) {
                            return (B1)("URL " + this.expr$1.apply((Expression)urlParam));
                        }
                    }
                }
                if (bl) {
                    LoadCidrQualifier loadCidrQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadCidrQualifier && (either = (loadCidrQualifier = (LoadCidrQualifier)privilegeQualifier).cidr()) instanceof Left) {
                        Left left = (Left)either;
                        String cidrString = (String)left.value();
                        if (Nil$.MODULE$.equals(list)) {
                            return (B1)("CIDR " + this.expr$1.quote(cidrString));
                        }
                    }
                }
                if (bl) {
                    LoadCidrQualifier loadCidrQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadCidrQualifier && (either = (loadCidrQualifier = (LoadCidrQualifier)privilegeQualifier).cidr()) instanceof Right) {
                        Right right = (Right)either;
                        Parameter cidrParam = (Parameter)right.value();
                        if (Nil$.MODULE$.equals(list)) {
                            return (B1)("CIDR " + this.expr$1.apply((Expression)cidrParam));
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(List<PrivilegeQualifier> x1) {
                boolean bl = false;
                .colon.colon colon2 = null;
                List<PrivilegeQualifier> list = x1;
                if (list instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)list;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list2 = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadAllQualifier && Nil$.MODULE$.equals(list2)) {
                        return true;
                    }
                }
                if (bl) {
                    LoadUrlQualifier loadUrlQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list3 = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadUrlQualifier && (either = (loadUrlQualifier = (LoadUrlQualifier)privilegeQualifier).url()) instanceof Left && Nil$.MODULE$.equals(list3)) {
                        return true;
                    }
                }
                if (bl) {
                    LoadUrlQualifier loadUrlQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list4 = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadUrlQualifier && (either = (loadUrlQualifier = (LoadUrlQualifier)privilegeQualifier).url()) instanceof Right && Nil$.MODULE$.equals(list4)) {
                        return true;
                    }
                }
                if (bl) {
                    LoadCidrQualifier loadCidrQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list5 = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadCidrQualifier && (either = (loadCidrQualifier = (LoadCidrQualifier)privilegeQualifier).cidr()) instanceof Left && Nil$.MODULE$.equals(list5)) {
                        return true;
                    }
                }
                if (bl) {
                    LoadCidrQualifier loadCidrQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list6 = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadCidrQualifier && (either = (loadCidrQualifier = (LoadCidrQualifier)privilegeQualifier).cidr()) instanceof Right && Nil$.MODULE$.equals(list6)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.expr$1 = expr$1;
            }
        };
    }

    public String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$prettifyGraphQualifier(GraphAction action, List<PrivilegeQualifier> qualifier) {
        if (action.name().equals("WRITE") || action.name().equals("SET LABEL") || action.name().equals("REMOVE LABEL")) {
            return "";
        }
        return this.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$extractQualifierString(qualifier);
    }

    private Option<String> extractQualifierPart(List<PrivilegeQualifier> qualifier) {
        PrivilegeQualifier privilegeQualifier;
        PrivilegeQualifier privilegeQualifier2;
        PrivilegeQualifier privilegeQualifier3;
        PrivilegeQualifier privilegeQualifier4;
        PrivilegeQualifier privilegeQualifier5;
        PrivilegeQualifier privilegeQualifier6;
        PrivilegeQualifier privilegeQualifier7;
        boolean bl = false;
        .colon.colon colon2 = null;
        List<PrivilegeQualifier> list = qualifier;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            PrivilegeQualifier privilegeQualifier8 = (PrivilegeQualifier)colon2.head();
            List list2 = colon2.next$access$1();
            if (privilegeQualifier8 instanceof LabelQualifier && Nil$.MODULE$.equals(list2)) {
                return new Some((Object)("NODE " + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ")));
            }
        }
        if (bl && (privilegeQualifier7 = (PrivilegeQualifier)colon2.head()) instanceof LabelQualifier) {
            return new Some((Object)("NODES " + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ")));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier9 = (PrivilegeQualifier)colon2.head();
            List list3 = colon2.next$access$1();
            if (privilegeQualifier9 instanceof LabelAllQualifier && Nil$.MODULE$.equals(list3)) {
                return new Some((Object)"NODES *");
            }
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier10 = (PrivilegeQualifier)colon2.head();
            List list4 = colon2.next$access$1();
            if (privilegeQualifier10 instanceof RelationshipQualifier && Nil$.MODULE$.equals(list4)) {
                return new Some((Object)("RELATIONSHIP " + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ")));
            }
        }
        if (bl && (privilegeQualifier6 = (PrivilegeQualifier)colon2.head()) instanceof RelationshipQualifier) {
            return new Some((Object)("RELATIONSHIPS " + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ")));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier11 = (PrivilegeQualifier)colon2.head();
            List list5 = colon2.next$access$1();
            if (privilegeQualifier11 instanceof RelationshipAllQualifier && Nil$.MODULE$.equals(list5)) {
                return new Some((Object)"RELATIONSHIPS *");
            }
        }
        if (bl && (privilegeQualifier5 = (PrivilegeQualifier)colon2.head()) instanceof ElementQualifier) {
            return new Some((Object)("ELEMENTS " + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ")));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier12 = (PrivilegeQualifier)colon2.head();
            List list6 = colon2.next$access$1();
            if (privilegeQualifier12 instanceof ElementsAllQualifier && Nil$.MODULE$.equals(list6)) {
                return new Some((Object)"ELEMENTS *");
            }
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier13 = (PrivilegeQualifier)colon2.head();
            List list7 = colon2.next$access$1();
            if (privilegeQualifier13 instanceof PatternQualifier) {
                PatternQualifier patternQualifier = (PatternQualifier)privilegeQualifier13;
                Seq<PrivilegeQualifier> lqs = patternQualifier.elementTypeQualifiers();
                Option<Variable> v = patternQualifier.variable();
                Expression e = patternQualifier.expression();
                Element element = patternQualifier.element();
                if (Nil$.MODULE$.equals(list7)) {
                    return new Some((Object)("FOR " + Prettifier$.extractPropertyRuleExpression$1(lqs, v, e, element)));
                }
            }
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier14 = (PrivilegeQualifier)colon2.head();
            List list8 = colon2.next$access$1();
            if (privilegeQualifier14 instanceof UserQualifier) {
                UserQualifier userQualifier = (UserQualifier)privilegeQualifier14;
                Expression user = userQualifier.username();
                if (Nil$.MODULE$.equals(list8)) {
                    return new Some((Object)("(" + this.escapeName().apply((Object)user) + ")"));
                }
            }
        }
        if (bl && (privilegeQualifier4 = (PrivilegeQualifier)colon2.head()) instanceof UserQualifier) {
            return new Some((Object)("(" + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ") + ")"));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier15 = (PrivilegeQualifier)colon2.head();
            List list9 = colon2.next$access$1();
            if (privilegeQualifier15 instanceof UserAllQualifier && Nil$.MODULE$.equals(list9)) {
                return new Some((Object)"(*)");
            }
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier16 = (PrivilegeQualifier)colon2.head();
            List list10 = colon2.next$access$1();
            if (privilegeQualifier16 instanceof AllQualifier && Nil$.MODULE$.equals(list10)) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier17 = (PrivilegeQualifier)colon2.head();
            List list11 = colon2.next$access$1();
            if (privilegeQualifier17 instanceof AllDatabasesQualifier && Nil$.MODULE$.equals(list11)) {
                return None$.MODULE$;
            }
        }
        if (bl && (privilegeQualifier3 = (PrivilegeQualifier)colon2.head()) instanceof ProcedureQualifier) {
            return new Some((Object)colon2.map((Function1)Prettifier$.stringify$1()).mkString(", "));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier18 = (PrivilegeQualifier)colon2.head();
            List list12 = colon2.next$access$1();
            if (privilegeQualifier18 instanceof ProcedureAllQualifier && Nil$.MODULE$.equals(list12)) {
                return new Some((Object)"*");
            }
        }
        if (bl && (privilegeQualifier2 = (PrivilegeQualifier)colon2.head()) instanceof FunctionQualifier) {
            return new Some((Object)colon2.map((Function1)Prettifier$.stringify$1()).mkString(", "));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier19 = (PrivilegeQualifier)colon2.head();
            List list13 = colon2.next$access$1();
            if (privilegeQualifier19 instanceof FunctionAllQualifier && Nil$.MODULE$.equals(list13)) {
                return new Some((Object)"*");
            }
        }
        if (bl && (privilegeQualifier = (PrivilegeQualifier)colon2.head()) instanceof SettingQualifier) {
            return new Some((Object)colon2.map((Function1)Prettifier$.stringify$1()).mkString(", "));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier20 = (PrivilegeQualifier)colon2.head();
            List list14 = colon2.next$access$1();
            if (privilegeQualifier20 instanceof SettingAllQualifier && Nil$.MODULE$.equals(list14)) {
                return new Some((Object)"*");
            }
        }
        return new Some((Object)"<unknown>");
    }

    public String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$extractQualifierString(List<PrivilegeQualifier> qualifier) {
        Option<String> qualifierPart = this.extractQualifierPart(qualifier);
        Option<String> option = qualifierPart;
        if (option instanceof Some) {
            Some some = (Some)option;
            String string = (String)some.value();
            return " " + string;
        }
        return "";
    }

    private Tuple3<String, Object, Object> extractDbScope(DatabaseScope dbScope) {
        boolean bl = false;
        NamedDatabasesScope namedDatabasesScope = null;
        DatabaseScope databaseScope = dbScope;
        if (databaseScope instanceof SingleNamedDatabaseScope) {
            SingleNamedDatabaseScope singleNamedDatabaseScope = (SingleNamedDatabaseScope)databaseScope;
            DatabaseName name = singleNamedDatabaseScope.database();
            return new Tuple3((Object)this.escapeName(name), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (databaseScope instanceof AllDatabasesScope) {
            return new Tuple3((Object)"*", (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (databaseScope instanceof DefaultDatabaseScope) {
            return new Tuple3((Object)"DEFAULT", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (databaseScope instanceof HomeDatabaseScope) {
            return new Tuple3((Object)"HOME", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (databaseScope instanceof NamedDatabasesScope) {
            SeqOps seqOps;
            bl = true;
            namedDatabasesScope = (NamedDatabasesScope)databaseScope;
            Seq<DatabaseName> seq = namedDatabasesScope.databases();
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                DatabaseName databaseName = (DatabaseName)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                return new Tuple3((Object)this.escapeName(databaseName), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        if (bl) {
            Seq<DatabaseName> databaseNames = namedDatabasesScope.databases();
            return new Tuple3((Object)this.escapeNames(databaseNames, DummyImplicit$.MODULE$.dummyImplicit()), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        throw new MatchError((Object)databaseScope);
    }

    private String extractGraphScope(GraphScope graphScope) {
        boolean bl = false;
        NamedGraphsScope namedGraphsScope = null;
        GraphScope graphScope2 = graphScope;
        if (graphScope2 instanceof SingleNamedGraphScope) {
            SingleNamedGraphScope singleNamedGraphScope = (SingleNamedGraphScope)graphScope2;
            DatabaseName name = singleNamedGraphScope.graph();
            return "GRAPH " + this.escapeName(name);
        }
        if (graphScope2 instanceof AllGraphsScope) {
            return "GRAPH *";
        }
        if (graphScope2 instanceof HomeGraphScope) {
            return "HOME GRAPH";
        }
        if (graphScope2 instanceof NamedGraphsScope) {
            SeqOps seqOps;
            bl = true;
            namedGraphsScope = (NamedGraphsScope)graphScope2;
            Seq<DatabaseName> seq = namedGraphsScope.graphs();
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                DatabaseName graph = (DatabaseName)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                return "GRAPH " + this.escapeName(graph);
            }
        }
        if (bl) {
            Seq<DatabaseName> graphs = namedGraphsScope.graphs();
            return "GRAPHS " + this.escapeNames(graphs, DummyImplicit$.MODULE$.dummyImplicit());
        }
        throw new MatchError((Object)graphScope2);
    }

    public String escapeName(Either<String, Parameter> name) {
        Either<String, Parameter> either = name;
        if (either instanceof Left) {
            Left left = (Left)either;
            String s = (String)left.value();
            return Stringifier.backtickEmpty((String)s);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Parameter p = (Parameter)right.value();
            return "$" + Stringifier.backtickEmpty((String)p.name());
        }
        throw new MatchError(either);
    }

    public String escapeName(DatabaseName name) {
        boolean bl = false;
        NamespacedName namespacedName = null;
        DatabaseName databaseName = name;
        if (databaseName instanceof NamespacedName) {
            bl = true;
            namespacedName = (NamespacedName)databaseName;
            List<String> names = namespacedName.nameComponents();
            Option<String> option = namespacedName.namespace();
            if (option instanceof Some) {
                Some some = (Some)option;
                String namespace = (String)some.value();
                return Stringifier.backtickEmpty((String)namespace) + "." + Stringifier.backtickEmpty((String)names.mkString("."));
            }
        }
        if (bl) {
            List<String> names = namespacedName.nameComponents();
            Option<String> option = namespacedName.namespace();
            if (None$.MODULE$.equals(option)) {
                return Stringifier.backtickEmpty((String)names.mkString("."));
            }
        }
        if (databaseName instanceof ParameterName) {
            ParameterName parameterName = (ParameterName)databaseName;
            Parameter p = parameterName.parameter();
            return "$" + Stringifier.backtickEmpty((String)p.name());
        }
        throw new MatchError((Object)databaseName);
    }

    public PartialFunction<Expression, String> escapeName() {
        return escapeName;
    }

    public String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$escapeNames(Seq<Expression> names) {
        return ((IterableOnceOps)names.map(this.escapeName())).mkString(", ");
    }

    private String escapeNames(Seq<DatabaseName> names, DummyImplicit d) {
        return ((IterableOnceOps)names.map((Function1 & Serializable)databaseName -> MODULE$.escapeName((DatabaseName)databaseName))).mkString(", ");
    }

    public String extractTopology(Topology topology) {
        String primariesString = (String)topology.primaries().flatMap((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Left left = null;
            Either either = x0$1;
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                int n = BoxesRunTime.unboxToInt((Object)left.value());
                if (1 == n) {
                    return new Some((Object)" 1 PRIMARY");
                }
            }
            if (bl) {
                int n = BoxesRunTime.unboxToInt((Object)left.value());
                return new Some((Object)(" " + n + " PRIMARIES"));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Parameter p = (Parameter)right.value();
                return new Some((Object)(" $" + Stringifier.backtick((String)p.name()) + " PRIMARIES"));
            }
            throw new MatchError((Object)either);
        }).getOrElse((Function0 & Serializable)() -> "");
        String maybeSecondariesString = (String)topology.secondaries().flatMap((Function1 & Serializable)x0$2 -> {
            boolean bl = false;
            Left left = null;
            Either either = x0$2;
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                int n = BoxesRunTime.unboxToInt((Object)left.value());
                if (1 == n) {
                    return new Some((Object)" 1 SECONDARY");
                }
            }
            if (bl) {
                int n = BoxesRunTime.unboxToInt((Object)left.value());
                return new Some((Object)(" " + n + " SECONDARIES"));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Parameter p = (Parameter)right.value();
                return new Some((Object)(" $" + Stringifier.backtick((String)p.name()) + " SECONDARIES"));
            }
            throw new MatchError((Object)either);
        }).getOrElse((Function0 & Serializable)() -> "");
        return " TOPOLOGY" + primariesString + maybeSecondariesString;
    }

    public String extractShardTopology(Option<Either<Object, Parameter>> replicas) {
        return (String)replicas.flatMap((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Left left = null;
            Either either = x0$1;
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                int n = BoxesRunTime.unboxToInt((Object)left.value());
                if (1 == n) {
                    return new Some((Object)" TOPOLOGY 1 REPLICA");
                }
            }
            if (bl) {
                int n = BoxesRunTime.unboxToInt((Object)left.value());
                return new Some((Object)(" TOPOLOGY " + n + " REPLICAS"));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Parameter p = (Parameter)right.value();
                return new Some((Object)(" TOPOLOGY $" + Stringifier.backtick((String)p.name()) + " REPLICAS"));
            }
            throw new MatchError((Object)either);
        }).getOrElse((Function0 & Serializable)() -> "");
    }

    public String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$extractAlterShardDefinition(ShardDefinition shardDefinition) {
        String graphTopology = (String)shardDefinition.graphShardTopology().map((Function1 & Serializable)topology -> MODULE$.extractTopology((Topology)topology)).map((Function1 & Serializable)s -> " SET GRAPH SHARD {SET " + s.trim() + "}").getOrElse((Function0 & Serializable)() -> "");
        String shardTopology = (String)shardDefinition.propertyShardReplicaCount().map((Function1 & Serializable)s -> " SET PROPERTY SHARD {SET" + MODULE$.extractShardTopology((Option<Either<Object, Parameter>>)new Some(s)) + "}").getOrElse((Function0 & Serializable)() -> "");
        return graphTopology + shardTopology;
    }

    public String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$extractShardDefinition(ShardDefinition shardDefinition) {
        String graphTopology = (String)shardDefinition.graphShardTopology().map((Function1 & Serializable)topology -> MODULE$.extractTopology((Topology)topology)).map((Function1 & Serializable)s -> "GRAPH SHARD {" + s.trim() + "} ").getOrElse((Function0 & Serializable)() -> "");
        String replicaString = this.extractShardTopology(shardDefinition.propertyShardReplicaCount());
        return " " + graphTopology + "PROPERTY SHARD {COUNT " + shardDefinition.propertyShardCount() + replicaString + "}";
    }

    public String stringifyOptions(Options options, ExpressionStringifier expr) {
        Options options2 = options;
        if (NoOptions$.MODULE$.equals(options2)) {
            return "";
        }
        if (options2 instanceof OptionsParam) {
            OptionsParam optionsParam = (OptionsParam)options2;
            Parameter parameter = optionsParam.parameter();
            return " OPTIONS " + expr.apply((Expression)parameter);
        }
        if (options2 instanceof OptionsMap) {
            OptionsMap optionsMap = (OptionsMap)options2;
            Map<String, Expression> map = optionsMap.map();
            return this.optionsToString(map, expr);
        }
        throw new MatchError((Object)options2);
    }

    private String optionsToString(Map<String, Expression> options, ExpressionStringifier expr) {
        if (options.nonEmpty()) {
            String mapString = ((IterableOnceOps)options.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String s = (String)tuple2._1();
                    Expression e = (Expression)tuple2._2();
                    return expr.backtick(s, true) + ": " + expr.apply(e);
                }
                throw new MatchError((Object)tuple2);
            })).mkString("{", ", ", "}");
            return " OPTIONS " + mapString;
        }
        return " OPTIONS {}";
    }

    public String maybeImmutable(boolean immutable) {
        if (immutable) {
            return " IMMUTABLE";
        }
        return "";
    }

    public Prettifier apply(ExpressionStringifier expr, Prettifier.ClausePrettifier extension, boolean useInCommands) {
        return new Prettifier(expr, extension, useInCommands);
    }

    public Prettifier.ClausePrettifier apply$default$2() {
        return Prettifier$EmptyExtension$.MODULE$;
    }

    public boolean apply$default$3() {
        return true;
    }

    public Option<Tuple3<ExpressionStringifier, Prettifier.ClausePrettifier, Object>> unapply(Prettifier x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.expr(), (Object)x$0.extension(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.useInCommands())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Prettifier$.class);
    }

    public static final /* synthetic */ String $anonfun$prettifyGraphPrivilege$1(String x$1) {
        return Stringifier.backtickEmpty((String)x$1);
    }

    public static final /* synthetic */ String $anonfun$prettifyGraphPrivilege$2(String x$1) {
        return Stringifier.backtickEmpty((String)x$1);
    }

    public static final String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$stringifyQualifiedName$1(String glob) {
        if (glob.contains("..")) {
            return Stringifier.backtick((String)glob, (boolean)false, (boolean)true, (boolean)true);
        }
        String escapedGlob = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(glob), '.')), (Function1 & Serializable)x$39 -> Stringifier.backtick((String)x$39, (boolean)false, (boolean)true, (boolean)true), ClassTag$.MODULE$.apply(String.class))).mkString(".");
        if (glob.isEmpty()) {
            return "``";
        }
        if (((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(glob)))).equals(BoxesRunTime.boxToCharacter((char)'.'))) {
            return escapedGlob + ".";
        }
        return escapedGlob;
    }

    private static final PartialFunction stringify$1() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends PrivilegeQualifier, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LabelQualifier) {
                    LabelQualifier labelQualifier = (LabelQualifier)A1;
                    String name = labelQualifier.label();
                    return (B1)Stringifier.backtickEmpty((String)name);
                }
                if (A1 instanceof RelationshipQualifier) {
                    RelationshipQualifier relationshipQualifier = (RelationshipQualifier)A1;
                    String name = relationshipQualifier.reltype();
                    return (B1)Stringifier.backtickEmpty((String)name);
                }
                if (A1 instanceof ElementQualifier) {
                    ElementQualifier elementQualifier = (ElementQualifier)A1;
                    String name = elementQualifier.value();
                    return (B1)Stringifier.backtickEmpty((String)name);
                }
                if (A1 instanceof UserQualifier) {
                    UserQualifier userQualifier = (UserQualifier)A1;
                    Expression name = userQualifier.username();
                    return (B1)Prettifier$.MODULE$.escapeName().apply((Object)name);
                }
                if (A1 instanceof ProcedureQualifier) {
                    ProcedureQualifier procedureQualifier = (ProcedureQualifier)A1;
                    String glob = procedureQualifier.glob();
                    return (B1)Prettifier$.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$stringifyQualifiedName$1(glob);
                }
                if (A1 instanceof FunctionQualifier) {
                    FunctionQualifier functionQualifier = (FunctionQualifier)A1;
                    String glob = functionQualifier.glob();
                    return (B1)Prettifier$.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$stringifyQualifiedName$1(glob);
                }
                if (A1 instanceof SettingQualifier) {
                    SettingQualifier settingQualifier = (SettingQualifier)A1;
                    String glob = settingQualifier.glob();
                    return (B1)Prettifier$.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$stringifyQualifiedName$1(glob);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(PrivilegeQualifier x1) {
                PrivilegeQualifier privilegeQualifier = x1;
                if (privilegeQualifier instanceof LabelQualifier) {
                    return true;
                }
                if (privilegeQualifier instanceof RelationshipQualifier) {
                    return true;
                }
                if (privilegeQualifier instanceof ElementQualifier) {
                    return true;
                }
                if (privilegeQualifier instanceof UserQualifier) {
                    return true;
                }
                if (privilegeQualifier instanceof ProcedureQualifier) {
                    return true;
                }
                if (privilegeQualifier instanceof FunctionQualifier) {
                    return true;
                }
                return privilegeQualifier instanceof SettingQualifier;
            }
        };
    }

    private static final String propertyAndWherePrettifier$1(Expression e2, Element element$1, Option variableNameString$1, String elementTypes$1) {
        String where = "WHERE " + ExpressionStringifier$.MODULE$.apply((Function1<Expression, String>)(Function1 & Serializable)e -> e.asCanonicalStringVal(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()).apply(e2);
        Element element = element$1;
        if (Node$.MODULE$.equals(element)) {
            return "(" + variableNameString$1.getOrElse((Function0 & Serializable)() -> "") + elementTypes$1 + ") " + where;
        }
        if (Relationship$.MODULE$.equals(element)) {
            return "()-[" + variableNameString$1.getOrElse((Function0 & Serializable)() -> "") + elementTypes$1 + "]-() " + where;
        }
        throw new MatchError((Object)element);
    }

    private static final String propertyInElementPrettifier$1(PropertyKeyName propertyKeyName, Expression value, Element element$1, Option variableNameString$1, String elementTypes$1) {
        Function1 & Serializable where = (Function1 & Serializable)varName -> "WHERE " + varName + "." + Stringifier.backtickEmpty((String)propertyKeyName.name()) + " = " + ExpressionStringifier$.MODULE$.apply((Function1<Expression, String>)(Function1 & Serializable)value -> value.asCanonicalStringVal(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()).apply(value);
        Element element = element$1;
        if (Node$.MODULE$.equals(element)) {
            String varName2 = (String)variableNameString$1.getOrElse((Function0 & Serializable)() -> "n");
            return "(" + varName2 + elementTypes$1 + ") " + where.apply((Object)varName2);
        }
        if (Relationship$.MODULE$.equals(element)) {
            String varName3 = (String)variableNameString$1.getOrElse((Function0 & Serializable)() -> "r");
            return "()-[" + varName3 + elementTypes$1 + "]-() " + where.apply((Object)varName3);
        }
        throw new MatchError((Object)element);
    }

    private static final String extractPropertyRuleExpression$1(Seq elementTypeQualifiers, Option variable, Expression expression, Element element) {
        Tuple2 tuple2;
        SeqOps seqOps;
        MapExpression mapExpression;
        Seq seq;
        String elementTypes2 = (String)new Some((Object)((IterableOnceOps)elementTypeQualifiers.flatMap((Function1 & Serializable)x0$1 -> {
            PrivilegeQualifier privilegeQualifier = x0$1;
            if (privilegeQualifier instanceof LabelQualifier) {
                LabelQualifier labelQualifier = (LabelQualifier)privilegeQualifier;
                return new Some((Object)Stringifier.backtickEmpty((String)labelQualifier.label()));
            }
            if (privilegeQualifier instanceof RelationshipQualifier) {
                RelationshipQualifier relationshipQualifier = (RelationshipQualifier)privilegeQualifier;
                return new Some((Object)Stringifier.backtickEmpty((String)relationshipQualifier.reltype()));
            }
            return None$.MODULE$;
        })).mkString("|")).filterNot((Function1 & Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)x$40.equals(""))).map((Function1 & Serializable)elementTypes -> ":" + elementTypes).getOrElse((Function0 & Serializable)() -> "");
        Option variableNameString = variable.map((Function1 & Serializable)v -> Stringifier.backtickEmpty((String)v.name()));
        boolean bl = false;
        In in = null;
        Expression expression2 = expression;
        if (expression2 instanceof MapExpression && (seq = (mapExpression = (MapExpression)expression2).items()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
            PropertyKeyName propertyKeyName = (PropertyKeyName)tuple2._1();
            Expression value = (Expression)tuple2._2();
            return Prettifier$.propertyInElementPrettifier$1(propertyKeyName, value, element, variableNameString, elementTypes2);
        }
        if (expression2 instanceof Equals) {
            Equals equals = (Equals)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)equals, element, variableNameString, elementTypes2);
        }
        if (expression2 instanceof NotEquals) {
            NotEquals notEquals = (NotEquals)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)notEquals, element, variableNameString, elementTypes2);
        }
        if (expression2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)greaterThan, element, variableNameString, elementTypes2);
        }
        if (expression2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)greaterThanOrEqual, element, variableNameString, elementTypes2);
        }
        if (expression2 instanceof LessThan) {
            LessThan lessThan = (LessThan)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)lessThan, element, variableNameString, elementTypes2);
        }
        if (expression2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)lessThanOrEqual, element, variableNameString, elementTypes2);
        }
        if (expression2 instanceof IsNull) {
            IsNull isNull = (IsNull)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)isNull, element, variableNameString, elementTypes2);
        }
        if (expression2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)isNotNull, element, variableNameString, elementTypes2);
        }
        if (expression2 instanceof In) {
            bl = true;
            in = (In)expression2;
            if (in.rhs() instanceof ListLiteral) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)in, element, variableNameString, elementTypes2);
            }
        }
        if (bl && in.rhs() instanceof ExplicitParameter) {
            return Prettifier$.propertyAndWherePrettifier$1((Expression)in, element, variableNameString, elementTypes2);
        }
        if (expression2 instanceof Not) {
            Not not = (Not)expression2;
            Expression innerExpression = not.rhs();
            boolean bl2 = false;
            In in2 = null;
            Expression expression3 = innerExpression;
            if (expression3 instanceof Equals) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, element, variableNameString, elementTypes2);
            }
            if (expression3 instanceof NotEquals) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, element, variableNameString, elementTypes2);
            }
            if (expression3 instanceof GreaterThan) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, element, variableNameString, elementTypes2);
            }
            if (expression3 instanceof GreaterThanOrEqual) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, element, variableNameString, elementTypes2);
            }
            if (expression3 instanceof LessThan) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, element, variableNameString, elementTypes2);
            }
            if (expression3 instanceof LessThanOrEqual) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, element, variableNameString, elementTypes2);
            }
            if (expression3 instanceof IsNull) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, element, variableNameString, elementTypes2);
            }
            if (expression3 instanceof IsNotNull) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, element, variableNameString, elementTypes2);
            }
            if (expression3 instanceof In) {
                bl2 = true;
                in2 = (In)expression3;
                if (in2.rhs() instanceof ListLiteral) {
                    return Prettifier$.propertyAndWherePrettifier$1((Expression)not, element, variableNameString, elementTypes2);
                }
            }
            if (bl2 && in2.rhs() instanceof ExplicitParameter) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, element, variableNameString, elementTypes2);
            }
            throw new IllegalStateException("Unknown expression: " + ExpressionStringifier$.MODULE$.apply((Function1<Expression, String>)(Function1 & Serializable)e -> e.asCanonicalStringVal(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()).apply((Expression)not));
        }
        throw new IllegalStateException("Unknown expression: " + ExpressionStringifier$.MODULE$.apply((Function1<Expression, String>)(Function1 & Serializable)e -> e.asCanonicalStringVal(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()).apply(expression2));
    }

    private Prettifier$() {
    }
}

