/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.UUID;
import org.neo4j.common.EntityType;
import org.neo4j.values.ElementIdDecoder;

public class ElementIdDecoderV1
implements ElementIdDecoder.VersionedElementIdDecoder {
    public static final byte ELEMENT_ID_FORMAT_VERSION = 1;

    @Override
    public long nodeId(String elementId) {
        return ElementIdDecoderV1.decode((String)elementId, (EntityType)EntityType.NODE).entityId;
    }

    @Override
    public long relationshipId(String elementId) {
        return ElementIdDecoderV1.decode((String)elementId, (EntityType)EntityType.RELATIONSHIP).entityId;
    }

    @Override
    public UUID database(String elementId) {
        return ElementIdDecoderV1.decodeDatabase(elementId);
    }

    public long decodeElementId(String elementId) {
        return ElementIdDecoderV1.decode((String)elementId).entityId;
    }

    public EntityType decodeElementType(String elementId) {
        return ElementIdDecoderV1.decode((String)elementId).entityType;
    }

    protected static ElementId decode(String id, EntityType expectedType) {
        ElementId elementId = ElementIdDecoderV1.decode(id);
        ElementIdDecoderV1.verifyEntityType(id, elementId.entityType, expectedType);
        return elementId;
    }

    protected static ElementId decode(String id) {
        try {
            String[] parts = ElementIdDecoderV1.readParts(id);
            byte header = Byte.parseByte(parts[0]);
            ElementIdDecoderV1.verifyVersion(id, header);
            UUID database = UUID.fromString(parts[1]);
            long entityId = Long.parseLong(parts[2]);
            EntityType entityType = ElementIdDecoderV1.decodeEntityType(id, header);
            return new ElementId(entityId, entityType, database);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected format.", id), e);
        }
    }

    protected static UUID decodeDatabase(String id) {
        try {
            String[] parts = ElementIdDecoderV1.readParts(id);
            byte header = Byte.parseByte(parts[0]);
            ElementIdDecoderV1.verifyVersion(id, header);
            return UUID.fromString(parts[1]);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected format.", id), e);
        }
    }

    private static String[] readParts(String id) {
        String[] parts = id.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected format.", id));
        }
        return parts;
    }

    private static void verifyVersion(String id, byte header) {
        byte version = (byte)(header >>> 2);
        if (version != 1) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected version %d", id, version));
        }
    }

    private static EntityType decodeEntityType(String id, byte header) {
        byte entityTypeId = (byte)(header & 3);
        return switch (entityTypeId) {
            case 0 -> EntityType.NODE;
            case 1 -> EntityType.RELATIONSHIP;
            default -> throw new IllegalArgumentException(String.format("Element ID %s has unknown entity type ID %s", id, entityTypeId));
        };
    }

    private static void verifyEntityType(String id, EntityType actual, EntityType expected) {
        if (actual != expected) {
            throw new IllegalArgumentException(String.format("Element ID %s has unexpected entity type %s, was expecting %s", id, actual, expected));
        }
    }

    protected record ElementId(long entityId, EntityType entityType, UUID database) {
    }
}

