/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class SortedKeysMapValue
extends MapValue {
    private static final long COMPILED_MAP_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(SortedKeysMapValue.class);
    private final String[] keys;
    private final AnyValue[] values;
    private static final long NOT_MEMOIZED = -1L;
    private volatile long memoizedEstimatedHeapUsage;

    public SortedKeysMapValue(String[] keys) {
        this(keys, new AnyValue[keys.length]);
    }

    public SortedKeysMapValue(String[] keys, AnyValue[] values) {
        assert (keys.length == values.length);
        assert (ArrayUtils.isSorted((Comparable[])keys));
        this.keys = keys;
        this.values = values;
        this.memoizedEstimatedHeapUsage = -1L;
    }

    @Override
    public Iterable<String> keySet() {
        return Arrays.asList(this.keys);
    }

    @Override
    public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
        for (int i = 0; i < this.keys.length; ++i) {
            f.accept((Object)this.keys[i], (Object)this.values[i]);
        }
    }

    public void internalPut(int index, AnyValue value) {
        assert (this.memoizedEstimatedHeapUsage == -1L);
        this.values[index] = value;
    }

    @Override
    public boolean containsKey(String key) {
        return Arrays.binarySearch(this.keys, key) >= 0;
    }

    @Override
    public AnyValue get(String key) {
        int index = Arrays.binarySearch(this.keys, key);
        return index >= 0 ? this.values[index] : Values.NO_VALUE;
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.length == 0;
    }

    public long estimatedHeapUsage() {
        long tmp = this.memoizedEstimatedHeapUsage;
        if (tmp == -1L) {
            int length = this.keys.length;
            tmp = COMPILED_MAP_VALUE_SHALLOW_SIZE + 2L * HeapEstimator.shallowSizeOfObjectArray((int)length);
            for (int i = 0; i < length; ++i) {
                tmp += this.values[i].estimatedHeapUsage() + HeapEstimator.sizeOf((String)this.keys[i]);
            }
            this.memoizedEstimatedHeapUsage = tmp;
        }
        return tmp;
    }
}

