/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.IdentifiedVirtualValue;
import org.neo4j.values.virtual.VirtualValueGroup;

public abstract class VirtualNodeValue
extends VirtualValue
implements IdentifiedVirtualValue {
    @Override
    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        VirtualNodeValue otherNode = (VirtualNodeValue)other;
        return Long.compare(this.id(), otherNode.id());
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        return Comparison.from(this.unsafeCompareTo(other, comparator));
    }

    @Override
    protected int computeHashToMemoize() {
        return Long.hashCode(this.id());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapNode(this);
    }

    @Override
    public final boolean equals(VirtualValue other) {
        if (!(other instanceof VirtualNodeValue)) {
            return false;
        }
        VirtualNodeValue that = (VirtualNodeValue)other;
        return that.equals(this);
    }

    protected boolean equals(VirtualNodeValue other) {
        return this.id() == other.id();
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.NODE;
    }
}

