/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.util.Optional;

public enum CypherVersion {
    Cypher5("5", "CYPHER 5", false, "cypher-5", 5),
    Cypher25("25", "CYPHER 25", false, "cypher-25", 25);

    public final String versionName;
    public final String description;
    public final boolean experimental;
    public final String persistedValue;
    private final int order;

    private CypherVersion(String versionName, String description, boolean experimental, String persistedValue, int order) {
        this.versionName = versionName;
        this.description = description;
        this.experimental = experimental;
        this.persistedValue = persistedValue;
        this.order = order;
    }

    public String toString() {
        return this.versionName;
    }

    public boolean isAfter(CypherVersion other) {
        return this.order > other.order;
    }

    public boolean isEqualOrAfter(CypherVersion other) {
        return this.order >= other.order;
    }

    public static CypherVersion fromStoredValue(String storedValue) {
        return CypherVersion.fromStoredValueOptional(storedValue).orElseThrow(() -> new IllegalArgumentException(storedValue + " is not a valid CypherVersion"));
    }

    public static Optional<CypherVersion> fromStoredValueOptional(Object storedValue) {
        for (CypherVersion version : CypherVersion.values()) {
            if (!version.persistedValue.equals(storedValue)) continue;
            return Optional.of(version);
        }
        return Optional.empty();
    }

    public static class Legacy {
        @Deprecated(since="2025.06", forRemoval=true)
        public static CypherVersion legacyVersion() {
            return Cypher5;
        }
    }
}

