/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.neo4j.string.EncodingUtils;

public final class ProcessUtils {
    private ProcessUtils() {
    }

    public static Path getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        return Paths.get(javaHome, "bin", "java");
    }

    public static List<String> getClassPathList() {
        return Arrays.asList(ProcessUtils.getClassPath().split(File.pathSeparator));
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static List<String> getModuleOptions() {
        String moduleOptions = System.getProperty("jdk.custom.options");
        if (StringUtils.isEmpty((CharSequence)moduleOptions)) {
            return Collections.emptyList();
        }
        return Arrays.stream(moduleOptions.split(" ")).filter(StringUtils::isNotBlank).map(String::trim).toList();
    }

    public static Process start(String ... arguments) throws IOException {
        return ProcessUtils.start(ProcessBuilder::inheritIO, arguments);
    }

    public static Process start(Consumer<ProcessBuilder> configurator, String ... arguments) throws IOException {
        ArrayList<String> args = ProcessUtils.javaExecutableCommandWith(arguments);
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        configurator.accept(processBuilder);
        return processBuilder.start();
    }

    public static Process start(String classpath, Consumer<ProcessBuilder> configurator, String ... arguments) throws IOException {
        ArrayList<String> args = ProcessUtils.javaExecutableCommandWith(classpath, arguments);
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        configurator.accept(processBuilder);
        return processBuilder.start();
    }

    public static int executeJava(ByteArrayOutputStream out, ByteArrayOutputStream err, Duration timeout, String ... arguments) throws IOException {
        ArrayList<String> args = ProcessUtils.javaExecutableCommandWith(arguments);
        return ProcessUtils.executeCommand(out, err, (String[])args.toArray(String[]::new), timeout);
    }

    public static String executeCommandWithOutput(String command, Duration timeout) {
        String[] commands = new StringTokenizer(command, StringMatcherFactory.INSTANCE.splitMatcher(), StringMatcherFactory.INSTANCE.quoteMatcher()).getTokenArray();
        return ProcessUtils.executeCommandWithOutput(commands, timeout);
    }

    public static String executeCommandWithOutput(String[] commands, Duration timeout) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        int exitCode = ProcessUtils.executeCommand(out, err, commands, timeout);
        String output = StringUtils.chomp((String)out.toString(EncodingUtils.getNativeCharset()));
        if (exitCode != 0) {
            throw new IllegalArgumentException(String.format("Command `%s` failed with exit code %s.%n%s%n%s", Arrays.toString(commands), exitCode, output, StringUtils.chomp((String)err.toString(EncodingUtils.getNativeCharset()))));
        }
        return output;
    }

    private static int executeCommand(ByteArrayOutputStream out, ByteArrayOutputStream err, String[] commands, Duration timeout) {
        Process process = ProcessUtils.executeProcess(out, err, commands, timeout);
        return process.exitValue();
    }

    private static Process executeProcess(ByteArrayOutputStream out, ByteArrayOutputStream err, String[] commands, Duration timeout) {
        Process process = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(commands);
            process = builder.start();
            Thread outGobbler = ProcessUtils.streamGobbler(process.getInputStream(), out);
            Thread errGobbler = ProcessUtils.streamGobbler(process.getErrorStream(), err);
            if (!process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new IllegalArgumentException(String.format("Timed out executing command `%s`", Arrays.toString(commands)));
            }
            outGobbler.join();
            errGobbler.join();
            Process process2 = process;
            return process2;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalArgumentException("Interrupted while executing command", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }

    private static Thread streamGobbler(InputStream from, OutputStream to) {
        Thread thread = new Thread(() -> {
            try {
                from.transferTo(to);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        thread.start();
        return thread;
    }

    private static ArrayList<String> javaExecutableCommandWith(String[] arguments) throws IOException {
        return ProcessUtils.javaExecutableCommandWith(ProcessUtils.getClassPath(), arguments);
    }

    private static ArrayList<String> javaExecutableCommandWith(String classpath, String[] arguments) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(ProcessUtils.getJavaExecutable().toString());
        List<String> moduleOptions = ProcessUtils.getModuleOptions();
        if (!moduleOptions.isEmpty()) {
            args.addAll(moduleOptions);
        }
        Path p = Files.createTempFile("jvm", ".args", new FileAttribute[0]);
        p.toFile().deleteOnExit();
        Files.writeString(p, (CharSequence)(ProcessUtils.systemProperties() + "-cp " + ProcessUtils.wrapSpaces(classpath)), StandardCharsets.UTF_8, new OpenOption[0]);
        args.add("@" + String.valueOf(p.normalize()));
        args.addAll(Arrays.asList(arguments));
        return args;
    }

    private static String systemProperties() {
        StringBuilder builder = new StringBuilder();
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = entry.getKey().toString();
            if (ProcessUtils.isJdkProperty(name)) continue;
            builder.append(ProcessUtils.systemProperty(name, entry.getValue().toString()));
            builder.append(" ");
        }
        return builder.toString();
    }

    private static boolean isJdkProperty(String name) {
        return name.startsWith("java") || name.startsWith("os") || name.startsWith("sun") || name.startsWith("user") || name.startsWith("line");
    }

    private static String systemProperty(String key, String value) {
        return "-D" + key + "=" + value;
    }

    private static String wrapSpaces(String value) {
        return value.replace(" ", "\" \"");
    }
}

