/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.utils;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.management.MBeanServer;

public final class DumpUtils {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";

    private DumpUtils() {
    }

    public static String legacyThreadDump() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        Properties systemProperties = System.getProperties();
        return DumpUtils.legacyThreadDump(threadMxBean, systemProperties);
    }

    public static String threadDump() {
        return DumpUtils.threadDump(DumpUtils.getHotspotDiagnosticMxBean());
    }

    public static String threadDump(HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean) {
        String string;
        Path path = DumpUtils.createThreadDumpTempFile();
        Files.delete(path);
        try {
            DumpUtils.threadDumpToFile(hotSpotDiagnosticMXBean, path);
            string = Files.readString(path);
        }
        catch (Throwable throwable) {
            try {
                Files.deleteIfExists(path);
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to dump threads", e);
            }
        }
        Files.deleteIfExists(path);
        return string;
    }

    public static void threadDumpToFile(Path file) {
        DumpUtils.threadDumpToFile(DumpUtils.getHotspotDiagnosticMxBean(), file);
    }

    public static String legacyThreadDump(ThreadMXBean threadMxBean, Properties systemProperties) {
        ThreadInfo[] threadInfos = threadMxBean.dumpAllThreads(true, true);
        String vmName = systemProperties.getProperty("java.vm.name");
        String vmVersion = systemProperties.getProperty("java.vm.version");
        String vmInfoString = systemProperties.getProperty("java.vm.info");
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Full thread dump %s (%s %s):\n\n", vmName, vmVersion, vmInfoString));
        for (ThreadInfo threadInfo : threadInfos) {
            sb.append(String.format("\"%s\" #%d\n", threadInfo.getThreadName(), threadInfo.getThreadId()));
            sb.append("   java.lang.Thread.State: ").append((Object)threadInfo.getThreadState()).append("\n");
            StackTraceElement[] stackTrace = threadInfo.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                StackTraceElement e = stackTrace[i];
                sb.append("\tat ").append(e).append('\n');
                if (i == 0 && threadInfo.getLockInfo() != null) {
                    Thread.State ts = threadInfo.getThreadState();
                    switch (ts) {
                        case BLOCKED: {
                            sb.append("\t-  blocked on ").append(threadInfo.getLockInfo()).append('\n');
                            break;
                        }
                        case WAITING: {
                            sb.append("\t-  waiting on ").append(threadInfo.getLockInfo()).append('\n');
                            break;
                        }
                        case TIMED_WAITING: {
                            sb.append("\t-  waiting on ").append(threadInfo.getLockInfo()).append('\n');
                            break;
                        }
                    }
                }
                for (MonitorInfo mi : threadInfo.getLockedMonitors()) {
                    if (mi.getLockedStackDepth() != i) continue;
                    sb.append("\t-  locked ").append(mi).append('\n');
                }
            }
        }
        return sb.toString();
    }

    private static void threadDumpToFile(HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean, Path file) {
        try {
            hotSpotDiagnosticMXBean.dumpThreads(file.toString(), HotSpotDiagnosticMXBean.ThreadDumpFormat.JSON);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to dump threads to %s".formatted(file), e);
        }
    }

    private static Path createThreadDumpTempFile() throws IOException {
        return Files.createTempFile("threadDump-" + ProcessHandle.current().pid() + "-" + Thread.currentThread().threadId(), ".json", new FileAttribute[0]);
    }

    private static HotSpotDiagnosticMXBean getHotspotDiagnosticMxBean() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            return ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
        }
        catch (IOException error) {
            throw new RuntimeException("Failed getting Hotspot Diagnostic MX bean", error);
        }
    }
}

