/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.util.Preconditions;

public class MemoryPoolImpl
implements MemoryPool {
    private final AtomicLong maxMemory = new AtomicLong();
    private final AtomicLong usedHeapBytes = new AtomicLong();
    private final AtomicLong usedNativeBytes = new AtomicLong();
    private final boolean strict;
    private final String limitSettingName;

    public MemoryPoolImpl(long limit, boolean strict, String limitSettingName) {
        this.limitSettingName = limitSettingName;
        this.maxMemory.setRelease(MemoryPoolImpl.validateSize(limit));
        this.strict = strict;
    }

    @Override
    public long usedHeap() {
        return this.usedHeapBytes.getAcquire();
    }

    @Override
    public long usedNative() {
        return this.usedNativeBytes.getAcquire();
    }

    @Override
    public long free() {
        return Math.max(0L, this.totalSize() - this.totalUsed());
    }

    @Override
    public void releaseHeap(long bytes) {
        this.usedHeapBytes.addAndGet(-bytes);
    }

    @Override
    public void releaseNative(long bytes) {
        this.usedNativeBytes.addAndGet(-bytes);
    }

    @Override
    public void reserveHeap(long bytes) {
        this.reserveMemory(bytes, this.usedHeapBytes, this.usedNativeBytes);
    }

    @Override
    public void reserveHeapNoThrow(long bytes) {
        this.usedHeapBytes.addAndGet(bytes);
    }

    @Override
    public void reserveNative(long bytes) {
        this.reserveMemory(bytes, this.usedNativeBytes, this.usedHeapBytes);
    }

    @Override
    public void reserveNativeNoThrow(long bytes) {
        this.usedNativeBytes.addAndGet(bytes);
    }

    private void reserveMemory(long bytes, AtomicLong poolCounter, AtomicLong complementPoolValue) {
        long localTotal;
        long max = this.strict ? this.maxMemory.getAcquire() : Long.MAX_VALUE;
        long newCounterValue = poolCounter.addAndGet(bytes);
        if (this.strict && (localTotal = newCounterValue + complementPoolValue.getAcquire()) > max) {
            poolCounter.addAndGet(-bytes);
            throw MemoryLimitExceededException.memoryPoolOutOfMemoryExceeded(bytes, max, localTotal - bytes, this.limitSettingName);
        }
    }

    @Override
    public long totalSize() {
        return this.maxMemory.getAcquire();
    }

    @Override
    public void setSize(long size) {
        this.maxMemory.setRelease(MemoryPoolImpl.validateSize(size));
    }

    private static long validateSize(long size) {
        if (size == 0L) {
            return Long.MAX_VALUE;
        }
        return Preconditions.requirePositive(size);
    }
}

