/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gqlstatus.DiagnosticRecordProperty;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlStandardDiagnosticRecordProperty;
import org.neo4j.gqlstatus.Neo4jDiagnosticRecordProperty;

public class DiagnosticRecord
implements Serializable {
    static final Map<String, Object> DEFAULT_DIAGNOSTIC_RECORD = new DiagnosticRecord().asMap();
    public static final String LEGACY_MESSAGE_KEY = "__legacy_message";
    private final Map<String, Object> innerDiagnosticRecord;

    public static Builder from() {
        return new Builder();
    }

    public DiagnosticRecord(String severity, GqlClassification classification, int offset, int line, int column, Map<String, Object> statusParameters) {
        this.innerDiagnosticRecord = GqlStandardDiagnosticRecordProperty.asMap();
        this.withProperty(Neo4jDiagnosticRecordProperty.SEVERITY, severity);
        this.withProperty(Neo4jDiagnosticRecordProperty.POSITION, new Neo4jDiagnosticRecordProperty.Position(offset, line, column));
        this.withProperty(Neo4jDiagnosticRecordProperty.STATUS_PARAMETERS, statusParameters);
        this.withProperty(Neo4jDiagnosticRecordProperty.CLASSIFICATION, classification);
        this.withProperty(Neo4jDiagnosticRecordProperty.STATUS_PARAMETERS, statusParameters);
    }

    public DiagnosticRecord(String severity, GqlClassification classification, int offset, int line, int column) {
        this.innerDiagnosticRecord = GqlStandardDiagnosticRecordProperty.asMap();
        this.withProperty(Neo4jDiagnosticRecordProperty.SEVERITY, severity);
        this.withProperty(Neo4jDiagnosticRecordProperty.CLASSIFICATION, classification);
        this.withProperty(Neo4jDiagnosticRecordProperty.POSITION, new Neo4jDiagnosticRecordProperty.Position(offset, line, column));
    }

    public DiagnosticRecord() {
        this.innerDiagnosticRecord = GqlStandardDiagnosticRecordProperty.asMap();
    }

    private DiagnosticRecord(Map<String, Object> jsonMap) {
        this.innerDiagnosticRecord = new HashMap<String, Object>(jsonMap);
        this.setDefaults(jsonMap, GqlStandardDiagnosticRecordProperty.asSet());
        this.setDefaults(jsonMap, Neo4jDiagnosticRecordProperty.asSet());
    }

    private void setDefaults(Map<String, Object> jsonMap, Set<DiagnosticRecordProperty<?>> properties) {
        for (DiagnosticRecordProperty<?> property : properties) {
            if (jsonMap.containsKey(property.key()) || property.disabled() || !property.defaultValue().isPresent()) continue;
            this.innerDiagnosticRecord.put(property.key(), property.serializeValue(property.defaultValue().get()));
        }
    }

    public void setStatusParameters(Map<String, Object> statusParameters) {
        this.withProperty(Neo4jDiagnosticRecordProperty.STATUS_PARAMETERS, statusParameters);
    }

    boolean hasPosition() {
        return this.innerDiagnosticRecord.containsKey(Neo4jDiagnosticRecordProperty.POSITION.key());
    }

    Map<String, Integer> getPositionMap() {
        return (Map)this.innerDiagnosticRecord.get(Neo4jDiagnosticRecordProperty.POSITION.key());
    }

    public Optional<String> getPosition() {
        Map positionMap = this.innerDiagnosticRecord.getOrDefault(Neo4jDiagnosticRecordProperty.POSITION.key(), Map.of());
        if (positionMap instanceof Map) {
            Map position = positionMap;
            String entries = position.entrySet().stream().map(k -> "%s: %s".formatted(k.getKey(), k.getValue())).collect(Collectors.joining(" "));
            return Optional.of(entries);
        }
        return Optional.empty();
    }

    public void updatePosition(int offset, int line, int column) {
        this.withProperty(Neo4jDiagnosticRecordProperty.POSITION, new Neo4jDiagnosticRecordProperty.Position(offset, line, column));
    }

    public int hashCode() {
        return this.innerDiagnosticRecord.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagnosticRecord that = (DiagnosticRecord)o;
        return this.innerDiagnosticRecord.equals(that.innerDiagnosticRecord);
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.innerDiagnosticRecord);
    }

    public <T> DiagnosticRecord withProperty(DiagnosticRecordProperty<T> property, T value) {
        DiagnosticRecord.withProperty(this.innerDiagnosticRecord, property, value);
        return this;
    }

    public static <T> Map<String, Object> withProperty(Map<String, Object> map, DiagnosticRecordProperty<T> property, T value) {
        if (property.disabled() || property.isValueOmitted(value)) {
            return map;
        }
        Optional.ofNullable(value).or(property::defaultValue).ifPresent(dv -> map.put(property.key(), property.serializeValue(dv)));
        return map;
    }

    public static class Builder {
        private final Map<String, Object> innerDiagnosticRecord = GqlStandardDiagnosticRecordProperty.asMap();

        private Builder() {
        }

        public Builder atPosition(int offset, int line, int column) {
            return this.withProperty(Neo4jDiagnosticRecordProperty.POSITION, new Neo4jDiagnosticRecordProperty.Position(offset, line, column));
        }

        public Builder withClassification(GqlClassification classification) {
            return this.withProperty(Neo4jDiagnosticRecordProperty.CLASSIFICATION, classification);
        }

        public Builder withSeverity(String severity) {
            return this.withProperty(Neo4jDiagnosticRecordProperty.SEVERITY, severity);
        }

        public <T> Builder withProperty(DiagnosticRecordProperty<T> property, T value) {
            DiagnosticRecord.withProperty(this.innerDiagnosticRecord, property, value);
            return this;
        }

        public DiagnosticRecord build() {
            return new DiagnosticRecord(this.innerDiagnosticRecord);
        }
    }
}

