/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.Map;
import java.util.Set;
import org.neo4j.gqlstatus.DiagnosticRecordProperty;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.NonGqlStandardDiagnosticRecordProperty;
import org.neo4j.gqlstatus.NotificationClassification;

public final class Neo4jDiagnosticRecordProperty {
    public static final NonGqlStandardDiagnosticRecordProperty<String> SEVERITY = NonGqlStandardDiagnosticRecordProperty.Builder.fromKey("_severity").build();
    public static final NonGqlStandardDiagnosticRecordProperty<GqlClassification> CLASSIFICATION = NonGqlStandardDiagnosticRecordProperty.Builder.fromKey("_classification").withValueOmittedPredicate(Neo4jDiagnosticRecordProperty::isOmittedClassification).withValueSerializer(String::valueOf).build();
    public static final NonGqlStandardDiagnosticRecordProperty<Map<String, Object>> STATUS_PARAMETERS = NonGqlStandardDiagnosticRecordProperty.Builder.fromKey("_status_parameters").disabled().build();
    public static final NonGqlStandardDiagnosticRecordProperty<Position> POSITION = NonGqlStandardDiagnosticRecordProperty.Builder.fromKey("_position").withValueSerializer(pos -> ((Position)pos).asMap()).build();
    private static final Set<DiagnosticRecordProperty<?>> ALL_PROPERTIES = Set.of(SEVERITY, CLASSIFICATION, POSITION);

    public static Set<DiagnosticRecordProperty<?>> asSet() {
        return ALL_PROPERTIES;
    }

    private static boolean isOmittedClassification(GqlClassification classification) {
        return classification == ErrorClassification.UNKNOWN || classification == NotificationClassification.UNKNOWN;
    }

    public record Position(int offset, int line, int column) {
        public Map<String, Integer> asMap() {
            return Map.of("offset", this.offset, "line", this.line, "column", this.column);
        }
    }
}

