/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.gqlstatus.DiagnosticRecordProperty;

public final class NonGqlStandardDiagnosticRecordProperty<T>
implements DiagnosticRecordProperty<T> {
    private final String key;
    private final boolean disabled;
    private final Predicate<T> isValueOmitted;
    private final Function<Object, Object> serializeValue;

    private NonGqlStandardDiagnosticRecordProperty(String key, Predicate<T> isValueOmitted, Function<Object, Object> serializeValue, boolean disabled) {
        this.key = key;
        this.disabled = disabled;
        this.isValueOmitted = isValueOmitted;
        this.serializeValue = serializeValue;
    }

    @Override
    public boolean isValueOmitted(T value) {
        return this.isValueOmitted.test(value);
    }

    @Override
    public Object serializeValue(Object value) {
        return this.serializeValue.apply(value);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public boolean disabled() {
        return this.disabled;
    }

    public static class Builder<T> {
        private final String key;
        private boolean disabled;
        private Predicate<T> isValueOmitted;
        private Function<Object, Object> serializeValue;

        private Builder(String key) {
            this.key = key;
            this.isValueOmitted = ignored -> false;
            this.serializeValue = Function.identity();
        }

        public static <T> Builder<T> fromKey(String key) throws IllegalArgumentException {
            if (key == null || key.isBlank() || !key.startsWith("_")) {
                throw new IllegalArgumentException("Invalid key: " + key);
            }
            return new Builder<T>(key);
        }

        public Builder<T> disabled() {
            this.disabled = true;
            return this;
        }

        public Builder<T> withValueOmittedPredicate(Predicate<T> isValueOmitted) {
            this.isValueOmitted = isValueOmitted;
            return this;
        }

        public Builder<T> withValueSerializer(Function<Object, Object> serializeValue) {
            this.serializeValue = serializeValue;
            return this;
        }

        public NonGqlStandardDiagnosticRecordProperty<T> build() {
            return new NonGqlStandardDiagnosticRecordProperty<T>(this.key, this.isValueOmitted, this.serializeValue, this.disabled);
        }
    }
}

