/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.List;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public enum PrivilegeGqlCodeEntity {
    ROLE("Role"),
    USER("User"),
    AUTHRULE("Auth rule"),
    DATABASE("Database"),
    DATABASE_ALIAS("Database alias");

    public final String description;

    private PrivilegeGqlCodeEntity(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static ErrorGqlStatusObject entityNotFound(PrivilegeGqlCodeEntity entity, String name, String paramName) {
        return PrivilegeGqlCodeEntity.entityNotFound(entity, name, paramName, null);
    }

    public static ErrorGqlStatusObject entityNotFound(PrivilegeGqlCodeEntity entity, String name, String paramName, String command) {
        ErrorGqlStatusObject cause = switch (entity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> PrivilegeGqlCodeEntity.userNotFound(name);
            case 0 -> PrivilegeGqlCodeEntity.roleNotFound(name);
            case 2 -> PrivilegeGqlCodeEntity.authRuleNotFound(name);
            case 3, 4 -> PrivilegeGqlCodeEntity.databaseNotFound(name);
        };
        ErrorGqlStatusObject paramCause = paramName == null ? cause : ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N51).withParam(GqlParams.StringParam.param, paramName).withCause(cause).build();
        return command == null ? PrivilegeGqlCodeEntity.invalidReference(paramCause) : PrivilegeGqlCodeEntity.invalidReference(ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42NA8).withParam(GqlParams.StringParam.cmd, command).withCause(paramCause).build());
    }

    public static ErrorGqlStatusObject entityAlreadyExists(PrivilegeGqlCodeEntity entity, String name) {
        return switch (entity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> PrivilegeGqlCodeEntity.invalidReference(PrivilegeGqlCodeEntity.userAlreadyExists(name));
            case 0 -> PrivilegeGqlCodeEntity.invalidReference(PrivilegeGqlCodeEntity.roleAlreadyExists(name));
            case 2 -> PrivilegeGqlCodeEntity.invalidReference(PrivilegeGqlCodeEntity.authRuleAlreadyExists(name));
            case 3, 4 -> PrivilegeGqlCodeEntity.invalidReference(PrivilegeGqlCodeEntity.databaseAlreadyExists(name));
        };
    }

    public static ErrorGqlStatusObject databasesAlreadyExists(List<String> names) {
        ErrorGqlStatusObject cause = ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N11).withParam(GqlParams.ListParam.dbList, names).build();
        return PrivilegeGqlCodeEntity.invalidReference(cause);
    }

    private static ErrorGqlStatusObject invalidReference(ErrorGqlStatusObject cause) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42001).withCause(cause).build();
    }

    private static ErrorGqlStatusObject userNotFound(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N09).withParam(GqlParams.StringParam.user, name).build();
    }

    private static ErrorGqlStatusObject roleNotFound(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N10).withParam(GqlParams.StringParam.role, name).build();
    }

    private static ErrorGqlStatusObject authRuleNotFound(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42NAD).withParam(GqlParams.StringParam.authRule, name).build();
    }

    private static ErrorGqlStatusObject databaseNotFound(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N00).withParam(GqlParams.StringParam.db, name).build();
    }

    private static ErrorGqlStatusObject userAlreadyExists(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N12).withParam(GqlParams.StringParam.user, name).build();
    }

    private static ErrorGqlStatusObject roleAlreadyExists(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N13).withParam(GqlParams.StringParam.role, name).build();
    }

    private static ErrorGqlStatusObject authRuleAlreadyExists(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42NAE).withParam(GqlParams.StringParam.authRule, name).build();
    }

    private static ErrorGqlStatusObject databaseAlreadyExists(String name) {
        return ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_42N11).withParam(GqlParams.ListParam.dbList, List.of(name)).build();
    }
}

