/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.printer;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.internal.CLibrary;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.DiscoveryException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.shell.cli.ErrorFormat;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.exception.AnsiFormattedException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.printer.AnsiFormattedText;
import org.neo4j.shell.printer.Printer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AnsiPrinter
implements Printer {
    private static final String ERROR_50N42 = "50N42";
    private static final Logger log = Logger.create();
    private static final List<String> TRIM_STATUS_DESC_START = List.of("error: ", "warn: ", "info: ");
    private final PrintStream out;
    private final PrintStream err;
    private final ErrorFormat errorFormat;
    private Format format;

    public AnsiPrinter(Format format, ErrorFormat errorFormat, PrintStream out, PrintStream err) {
        this.format = format;
        this.out = out;
        this.err = err;
        this.errorFormat = errorFormat;
        try {
            if (AnsiPrinter.isOutputInteractive()) {
                Ansi.setEnabled((boolean)true);
                AnsiConsole.systemInstall();
            } else {
                Ansi.setEnabled((boolean)false);
            }
        }
        catch (Throwable t) {
            log.warn("Not running on a distro with standard c library, disabling Ansi", t);
            Ansi.setEnabled((boolean)false);
        }
    }

    private static Throwable getRootCause(Throwable th) {
        Throwable cause = th;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private static boolean isOutputInteractive() {
        return 1 == CLibrary.isatty((int)CLibrary.STDOUT_FILENO) && 1 == CLibrary.isatty((int)CLibrary.STDERR_FILENO);
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(Format format) {
        this.format = format;
    }

    @Override
    public void printError(Throwable throwable) {
        this.printError(this.getFormattedMessage(throwable, Optional.empty()));
    }

    @Override
    public void printError(Throwable throwable, String query) {
        this.printError(this.getFormattedMessage(throwable, Optional.of(query)));
    }

    @Override
    public void printError(String s) {
        this.err.println(s);
    }

    @Override
    public void printOut(String msg) {
        this.out.println(msg);
    }

    public String getFormattedMessage(Throwable e, Optional<String> query) {
        Neo4jException driverException;
        AnsiFormattedText msg = AnsiFormattedText.s().brightRed();
        if (e instanceof AnsiFormattedException) {
            AnsiFormattedException ae = (AnsiFormattedException)e;
            msg.append(ae.getFormattedMessage());
        } else if (e instanceof ClientException && e.getMessage() != null && e.getMessage().contains("Missing username")) {
            msg.append(e.getMessage()).append("\nPlease specify --username, and optionally --password, as argument(s)").append("\nor as environment variable(s), NEO4J_USERNAME, and NEO4J_PASSWORD respectively.").append("\nSee --help for more info.");
        } else if (this.errorFormat == ErrorFormat.GQL && e instanceof Neo4jException && !ERROR_50N42.equals((driverException = (Neo4jException)e).gqlStatus())) {
            boolean first = true;
            for (Neo4jException gqlError : AnsiPrinter.collectGqlExceptions(driverException)) {
                if (!first) {
                    msg.append(System.lineSeparator()).append("  ");
                }
                msg.append(gqlError.gqlStatus()).append(": ").append(AnsiPrinter.trimStatusDesc(AnsiPrinter.formatStatusDescriptionWithPositionQueryAndOffset(gqlError, query)));
                first = false;
            }
        } else if (this.errorFormat == ErrorFormat.STACKTRACE) {
            msg.append(Exceptions.stringify((Throwable)e));
        } else {
            Throwable cause = e;
            if (e instanceof ServiceUnavailableException) {
                Throwable[] suppressed;
                for (Throwable s : suppressed = e.getSuppressed()) {
                    if (!(s instanceof DiscoveryException)) continue;
                    cause = AnsiPrinter.getRootCause(s);
                    break;
                }
            }
            if (cause.getMessage() != null) {
                msg.append(cause.getMessage());
            } else {
                msg.append(cause.getClass().getSimpleName());
            }
        }
        return msg.resetAndRender();
    }

    private static List<Neo4jException> collectGqlExceptions(Neo4jException e) {
        ArrayList<Neo4jException> exceptionsWithCauses = new ArrayList<Neo4jException>();
        while (e != null) {
            exceptionsWithCauses.add(e);
            e = e.gqlCause().orElse(null);
        }
        return exceptionsWithCauses.reversed();
    }

    private static String trimStatusDesc(String in) {
        for (String toTrim : TRIM_STATUS_DESC_START) {
            if (!in.startsWith(toTrim)) continue;
            return in.substring(toTrim.length());
        }
        return in;
    }

    private static String formatStatusDescriptionWithPositionQueryAndOffset(Neo4jException ex, Optional<String> query) {
        String statusDescr = ex.statusDescription();
        if (query.isPresent() && ex.gqlCause().isEmpty()) {
            int line = -1;
            int column = -1;
            int offset = -1;
            Object v = ex.diagnosticRecord().get("_position");
            if (v instanceof MapValue) {
                MapValue position = (MapValue)v;
                if (position.containsKey("line")) {
                    line = position.get("line").asInt();
                }
                if (position.containsKey("column")) {
                    column = position.get("column").asInt();
                }
                if (position.containsKey("offset")) {
                    offset = position.get("offset").asInt();
                }
            }
            if (offset >= 0) {
                Object errorLine;
                String[] split = query.get().split("\n");
                try {
                    String[] stringArray;
                    String string = System.lineSeparator();
                    if (split.length != 0) {
                        stringArray = split;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "";
                    }
                    errorLine = string + SyntaxException.findErrorLine((int)offset, (String[])stringArray);
                }
                catch (Exception e) {
                    errorLine = "";
                }
                return "%s (line %d, column %d (offset: %d))%s".formatted(statusDescr, line, column, offset, errorLine);
            }
        }
        return statusDescr;
    }
}

