/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.startup;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.shell.Main;
import org.neo4j.shell.startup.IgnoringSignalHandler;
import sun.misc.Signal;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CypherShellBoot {
    public static final IntSet SUPPORTED_JVM_VERSIONS = IntSets.immutable.of(new int[]{21, 25});

    public static void main(String[] args) throws IOException, InterruptedException {
        int exitCode;
        CypherShellBoot.jvmCheck();
        Signal.handle(new Signal("INT"), new IgnoringSignalHandler());
        ProcessBuilder processBuilder = new ProcessBuilder(CypherShellBoot.command(args));
        processBuilder.inheritIO();
        processBuilder.environment().putAll(CypherShellBoot.environment());
        Process process = null;
        try {
            process = processBuilder.start();
            exitCode = process.waitFor();
        }
        catch (Throwable e) {
            if (process != null) {
                process.destroyForcibly();
            }
            throw e;
        }
        System.exit(exitCode);
    }

    private static void jvmCheck() {
        if (!SUPPORTED_JVM_VERSIONS.contains(Runtime.version().feature())) {
            System.err.println("You are using an unsupported version of the Java runtime. Please use Java(TM) 21 or Java(TM) 25.");
        }
    }

    private static List<String> command(String[] args) {
        String javaCommand = ProcessHandle.current().info().command().orElseThrow(() -> new IllegalStateException("Wasn't able to figure out java binary"));
        String classPath = System.getProperty("app.home") + File.separator + "lib" + File.separator + "*";
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaCommand);
        command.addAll(CypherShellBoot.jvmInputArguments());
        command.add("-cp");
        command.add(classPath);
        command.add(Main.class.getName());
        command.addAll(Arrays.asList(args));
        return command;
    }

    private static Map<String, String> environment() {
        if (System.getenv() == null) {
            return Map.of();
        }
        return System.getenv();
    }

    private static List<String> jvmInputArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
        arguments.addAll(CypherShellBoot.extraJvmArguments());
        return arguments;
    }

    private static List<String> extraJvmArguments() {
        return List.of("--add-opens", "java.base/java.net=ALL-UNNAMED", "--add-opens", "java.base/java.lang=ALL-UNNAMED", "--add-opens", "java.base/java.nio=ALL-UNNAMED");
    }
}

